/*
 * Decompiled with CFR 0.152.
 */
package main.java.model;

import java.util.ArrayList;
import java.util.List;
import main.java.model.CategoricalCharacter;
import main.java.model.ICharacter;
import main.java.model.QuantitativeCharacter;
import main.java.model.State;

public class Character
implements ICharacter {
    private String name = null;
    private String id = null;
    public float weight = 3.0f;
    private ICharacter parentCharacter = null;
    private List<State> inapplicableStates = null;
    private List<ICharacter> childCharacters = null;

    public Character() {
        this(null);
    }

    public Character(String name) {
        this.name = name;
        this.inapplicableStates = new ArrayList<State>();
        this.childCharacters = new ArrayList<ICharacter>();
    }

    @Override
    public boolean isSupportsCategoricalData() {
        return false;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public float getWeight() {
        return this.weight;
    }

    @Override
    public void setWeight(float weight) {
        this.weight = weight;
    }

    @Override
    public List<State> getInapplicableStates() {
        return this.inapplicableStates;
    }

    @Override
    public void setInapplicableStates(List<State> inapplicableStates) {
        this.inapplicableStates = inapplicableStates;
    }

    @Override
    public ICharacter getParentCharacter() {
        return this.parentCharacter;
    }

    @Override
    public void setParentCharacter(ICharacter parentCharacter) {
        this.parentCharacter = parentCharacter;
        this.parentCharacter.getChildCharacters().add(this);
    }

    @Override
    public List<ICharacter> getChildCharacters() {
        return this.childCharacters;
    }

    @Override
    public void setChildCharacters(List<ICharacter> childCharacters) {
        this.childCharacters = childCharacters;
    }

    @Override
    public List<ICharacter> getAllChildren() {
        ArrayList<ICharacter> allChildrenCharacter = new ArrayList<ICharacter>();
        this.addChildrenToList(allChildrenCharacter, this);
        return allChildrenCharacter;
    }

    private void addChildrenToList(List<ICharacter> allChildrenCharacter, ICharacter character) {
        for (ICharacter childCharacter : character.getChildCharacters()) {
            allChildrenCharacter.add(childCharacter);
            this.addChildrenToList(allChildrenCharacter, childCharacter);
        }
    }

    public ICharacter clone() {
        Character newCharacter = null;
        if (this.isSupportsCategoricalData()) {
            newCharacter = new CategoricalCharacter();
            ((CategoricalCharacter)newCharacter).setStates(((CategoricalCharacter)this).getStates());
        } else {
            newCharacter = new QuantitativeCharacter();
        }
        newCharacter.setChildCharacters(this.getChildCharacters());
        newCharacter.setId(this.getId());
        newCharacter.setInapplicableStates(this.getInapplicableStates());
        newCharacter.setName(this.getName());
        newCharacter.setParentCharacter(this.getParentCharacter());
        return newCharacter;
    }

    public String toString() {
        return this.name;
    }
}

