/*
 * Decompiled with CFR 0.152.
 */
package main.java.model;

import java.util.ArrayList;
import java.util.List;
import main.java.model.DataSet;
import main.java.model.ICharacter;
import main.java.model.State;
import main.java.model.Taxon;

public class SingleAccessKeyNode {
    private ICharacter character = null;
    private Object characterState = null;
    private List<Object> otherCharacterStates = null;
    private List<SingleAccessKeyNode> children = null;
    private String nodeDescription = null;
    private List<Taxon> remainingTaxa = null;

    public SingleAccessKeyNode() {
        this(null, null);
    }

    public SingleAccessKeyNode(ICharacter character, Object characterState) {
        this.character = character;
        this.characterState = characterState;
        this.otherCharacterStates = new ArrayList<Object>();
        this.children = new ArrayList<SingleAccessKeyNode>();
        this.remainingTaxa = new ArrayList<Taxon>();
    }

    public ICharacter getCharacter() {
        return this.character;
    }

    public void setCharacter(ICharacter character) {
        this.character = character;
    }

    public Object getCharacterState() {
        return this.characterState;
    }

    public void setCharacterState(Object characterState) {
        this.characterState = characterState;
    }

    public List<Object> getOtherCharacterStates() {
        return this.otherCharacterStates;
    }

    public void setOtherCharacterStates(List<Object> otherCharacterStates) {
        this.otherCharacterStates = otherCharacterStates;
    }

    public void addOtherCharacterStates(Object otherCharacterState) {
        this.otherCharacterStates.add(otherCharacterState);
    }

    public String getStringStates() {
        return this.getStatesToString(" OR ");
    }

    public String getStatesToString(String separator) {
        String result = "";
        if (this.getCharacterState() instanceof State) {
            result = ((State)this.getCharacterState()).getName();
            for (Object state : this.getOtherCharacterStates()) {
                if (!(state instanceof State)) continue;
                result = String.valueOf(result) + separator + ((State)state).getName();
            }
        }
        return result;
    }

    public List<SingleAccessKeyNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<SingleAccessKeyNode> children) {
        this.children = children;
    }

    public void addChild(SingleAccessKeyNode singleAccessKeyNode) {
        this.children.add(singleAccessKeyNode);
    }

    public List<Taxon> getRemainingTaxa() {
        return this.remainingTaxa;
    }

    public void setRemainingTaxa(List<Taxon> remainingTaxa) {
        this.remainingTaxa = remainingTaxa;
    }

    public boolean hasChild() {
        return this.children.size() > 0;
    }

    public boolean isEmpty() {
        return this.character == null || this.characterState == null;
    }

    public String getNodeDescription() {
        return this.nodeDescription;
    }

    public void setNodeDescription(String nodeDescription) {
        this.nodeDescription = nodeDescription;
    }

    public String toString() {
        return String.valueOf(this.character.toString()) + " --> " + this.characterState.toString();
    }

    public boolean isChildrenContainsImages(DataSet dataSet) {
        for (SingleAccessKeyNode childNode : this.getChildren()) {
            if (!childNode.getCharacter().isSupportsCategoricalData() || ((State)childNode.getCharacterState()).getFirstImageKey() == null || dataSet.getMediaObject(((State)childNode.getCharacterState()).getFirstImageKey()) == null || !dataSet.getMediaObject(((State)childNode.getCharacterState()).getFirstImageKey()).startsWith("http")) continue;
            return true;
        }
        return false;
    }
}

