/*
 * Decompiled with CFR 0.152.
 */
package main.java.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import main.java.model.DataSet;

public class Taxon {
    public static final int NB_PATH_IN_KEY = 0;
    public static final int SHORTEST_PATH_IN_KEY = 1;
    public static final int LONGEST_PATH_IN_KEY = 2;
    public static final int AVERAGE_PATHLENGTH_IN_KEY = 3;
    public static final int SUM_PATHLENGTHS_IN_KEY = 4;
    private String id;
    private String name = null;
    private List<String> mediaObjectKeys = null;
    private HashMap<Integer, Float> pathStatistics;

    public Taxon() {
        this(null);
    }

    public Taxon(String name) {
        this.name = name;
        this.mediaObjectKeys = new ArrayList<String>();
        this.pathStatistics = new HashMap();
        this.pathStatistics.put(0, new Float(0.0f));
        this.pathStatistics.put(1, new Float(0.0f));
        this.pathStatistics.put(2, new Float(0.0f));
        this.pathStatistics.put(3, new Float(0.0f));
        this.pathStatistics.put(4, new Float(0.0f));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getMediaObjectKeys() {
        return this.mediaObjectKeys;
    }

    public void setMediaObjectKeys(List<String> mediaObjectKeys) {
        this.mediaObjectKeys = mediaObjectKeys;
    }

    public String getFirstImage(DataSet dataSet) {
        if (dataSet != null && this.mediaObjectKeys != null && this.mediaObjectKeys.size() > 0 && dataSet.getMediaObject(this.mediaObjectKeys.get(0)).startsWith("http")) {
            return dataSet.getMediaObject(this.mediaObjectKeys.get(0));
        }
        return null;
    }

    public String getFirstImageKey() {
        if (this.mediaObjectKeys.size() > 0) {
            return this.mediaObjectKeys.get(0);
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public HashMap<Integer, Float> getTaxonStatistics() {
        return this.pathStatistics;
    }

    public void setTaxonStatistics(HashMap<Integer, Float> taxonStatistics) {
        this.pathStatistics = taxonStatistics;
    }

    public void updatePathStatistics(Float pathLength) {
        float oldNbPath = this.pathStatistics.get(0).floatValue();
        float oldSumPathLength = this.pathStatistics.get(4).floatValue();
        float newNbPath = oldNbPath + 1.0f;
        float newSumPathLength = oldSumPathLength + pathLength.floatValue();
        float newAveragePathLength = newSumPathLength / newNbPath;
        this.pathStatistics.put(3, Float.valueOf(newAveragePathLength));
        this.pathStatistics.put(0, Float.valueOf(newNbPath));
        this.pathStatistics.put(4, Float.valueOf(newSumPathLength));
        if (this.pathStatistics.get(1).floatValue() == 0.0f) {
            this.pathStatistics.put(1, pathLength);
        } else if (pathLength.floatValue() < this.pathStatistics.get(1).floatValue()) {
            this.pathStatistics.put(1, pathLength);
        }
        if (this.pathStatistics.get(2).floatValue() == 0.0f) {
            this.pathStatistics.put(2, pathLength);
        } else if (pathLength.floatValue() > this.pathStatistics.get(2).floatValue()) {
            this.pathStatistics.put(2, pathLength);
        }
    }
}

