/*
 * Decompiled with CFR 0.152.
 */
package main.java.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import main.java.model.CategoricalCharacter;
import main.java.model.CodedDescription;
import main.java.model.DataSet;
import main.java.model.ICharacter;
import main.java.model.QuantitativeCharacter;
import main.java.model.QuantitativeMeasure;
import main.java.model.SingleAccessKeyNode;
import main.java.model.SingleAccessKeyTree;
import main.java.model.State;
import main.java.model.Taxon;
import main.java.utils.Utils;

public class IdentificationKeyGenerator {
    private SingleAccessKeyTree singleAccessKeyTree = null;
    private DataSet dataset = null;
    private Utils utils = null;
    private int maxNbStatesPerCharacter;

    public IdentificationKeyGenerator(DataSet dataset, Utils utils) throws Exception {
        this.dataset = dataset;
        this.utils = utils;
    }

    public void createIdentificationKey() throws Exception {
        this.singleAccessKeyTree = new SingleAccessKeyTree(this.utils);
        this.singleAccessKeyTree.setDataSet(this.dataset);
        this.maxNbStatesPerCharacter = this.calculateMaxNbStatesPerCharacter();
        SingleAccessKeyNode rootNode = new SingleAccessKeyNode();
        rootNode.setRemainingTaxa(this.dataset.getTaxa());
        this.singleAccessKeyTree.setRoot(rootNode);
        this.calculateSingleAccessKeyNodeChild(rootNode, this.dataset.getCharacters(), new ArrayList<Taxon>(this.dataset.getTaxa()), new ArrayList<ICharacter>());
        boolean isOptimized = true;
        while (isOptimized) {
            isOptimized = this.optimizeSingleAccessKeyTree(null, this.singleAccessKeyTree.getRoot(), false);
        }
    }

    private void calculateSingleAccessKeyNodeChild(SingleAccessKeyNode parentNode, List<ICharacter> remainingCharacters, List<Taxon> remainingTaxa, List<ICharacter> alreadyUsedCharacter) throws Exception {
        if (remainingCharacters.size() > 0 && remainingTaxa.size() > 1) {
            ArrayList<ICharacter> childDependantCharacters = new ArrayList<ICharacter>();
            Map<ICharacter, Float> charactersScore = this.charactersScores(remainingCharacters, remainingTaxa, childDependantCharacters, alreadyUsedCharacter);
            ICharacter selectedCharacter = this.bestCharacter(charactersScore, remainingTaxa);
            if (!this.utils.getScoreMethod().equalsIgnoreCase("xper")) {
                for (ICharacter character : charactersScore.keySet()) {
                    if (!(charactersScore.get(character).floatValue() <= 0.0f)) continue;
                    remainingCharacters.removeAll(character.getAllChildren());
                    remainingCharacters.remove(character);
                }
            }
            List<Taxon> notDescribedTaxa = null;
            if (selectedCharacter.isSupportsCategoricalData()) {
                notDescribedTaxa = this.getNotDescribedTaxa(remainingTaxa, (CategoricalCharacter)selectedCharacter);
                remainingTaxa.removeAll(notDescribedTaxa);
            } else {
                notDescribedTaxa = this.getNotDescribedTaxa(remainingTaxa, (QuantitativeCharacter)selectedCharacter);
                remainingTaxa.removeAll(notDescribedTaxa);
            }
            if (selectedCharacter.isSupportsCategoricalData()) {
                ArrayList<SingleAccessKeyNode> futureChildNodes = new ArrayList<SingleAccessKeyNode>();
                for (State state : ((CategoricalCharacter)selectedCharacter).getStates()) {
                    List<Taxon> newRemainingTaxa = this.getRemainingTaxa(remainingTaxa, (CategoricalCharacter)selectedCharacter, state);
                    if (newRemainingTaxa.size() <= 0) continue;
                    SingleAccessKeyNode node = new SingleAccessKeyNode();
                    node.setCharacter(selectedCharacter);
                    node.setRemainingTaxa(newRemainingTaxa);
                    node.setCharacterState(state);
                    if (this.utils.isMergeCharacterStatesIfSameDiscimination() && this.mergeNodesIfSameDiscrimination(futureChildNodes, node)) continue;
                    futureChildNodes.add(node);
                    parentNode.addChild(node);
                    ArrayList<ICharacter> newRemainingCharacters = new ArrayList<ICharacter>(remainingCharacters);
                    newRemainingCharacters.remove(selectedCharacter);
                    List<ICharacter> inapplicableCharacters = this.dataset.getInapplicableCharacters(newRemainingCharacters, selectedCharacter, state);
                    newRemainingCharacters.removeAll(inapplicableCharacters);
                    if (this.utils.isPruning() && remainingTaxa.containsAll(newRemainingTaxa) && newRemainingTaxa.containsAll(remainingTaxa) && !childDependantCharacters.contains(selectedCharacter)) {
                        node.setNodeDescription(Utils.getBundleConfElement("message.warning.pruning"));
                        continue;
                    }
                    this.calculateSingleAccessKeyNodeChild(node, newRemainingCharacters, newRemainingTaxa, new ArrayList<ICharacter>(alreadyUsedCharacter));
                }
            } else {
                alreadyUsedCharacter.add(selectedCharacter);
                List<QuantitativeMeasure> quantitativeMeasures = this.splitQuantitativeCharacter(selectedCharacter, remainingTaxa);
                for (QuantitativeMeasure quantitativeMeasure : quantitativeMeasures) {
                    List<Taxon> newRemainingTaxa = this.getRemainingTaxa(remainingTaxa, (QuantitativeCharacter)selectedCharacter, quantitativeMeasure);
                    if (newRemainingTaxa.size() <= 0) continue;
                    SingleAccessKeyNode node = new SingleAccessKeyNode();
                    node.setCharacter(selectedCharacter);
                    node.setRemainingTaxa(newRemainingTaxa);
                    node.setCharacterState(quantitativeMeasure);
                    parentNode.addChild(node);
                    ArrayList<ICharacter> newRemainingCharacters = new ArrayList<ICharacter>(remainingCharacters);
                    if (this.utils.isPruning() && remainingTaxa.containsAll(newRemainingTaxa) && newRemainingTaxa.containsAll(remainingTaxa) && !childDependantCharacters.contains(selectedCharacter)) {
                        node.setNodeDescription(Utils.getBundleConfElement("message.warning.pruning"));
                        continue;
                    }
                    if (parentNode.getRemainingTaxa().size() == newRemainingTaxa.size()) {
                        newRemainingCharacters.remove(selectedCharacter);
                        this.calculateSingleAccessKeyNodeChild(node, newRemainingCharacters, newRemainingTaxa, new ArrayList<ICharacter>(alreadyUsedCharacter));
                        continue;
                    }
                    this.calculateSingleAccessKeyNodeChild(node, newRemainingCharacters, newRemainingTaxa, new ArrayList<ICharacter>(alreadyUsedCharacter));
                }
            }
            if (this.utils.getVerbosity().contains("o") && notDescribedTaxa != null && notDescribedTaxa.size() > 0) {
                SingleAccessKeyNode notDescribedNode = new SingleAccessKeyNode();
                notDescribedNode.setCharacter(selectedCharacter);
                notDescribedNode.setRemainingTaxa(notDescribedTaxa);
                notDescribedNode.setCharacterState(new State(Utils.getBundleConfElement("message.notDescribed")));
                parentNode.addChild(notDescribedNode);
            }
        }
    }

    private boolean mergeNodesIfSameDiscrimination(List<SingleAccessKeyNode> futureChildNodes, SingleAccessKeyNode node) {
        for (SingleAccessKeyNode futureChildNode : futureChildNodes) {
            if ((node.getRemainingTaxa().size() <= 1 || !futureChildNode.getRemainingTaxa().containsAll(node.getRemainingTaxa())) && (futureChildNode.getRemainingTaxa().size() <= 1 || !node.getRemainingTaxa().containsAll(futureChildNode.getRemainingTaxa()))) continue;
            futureChildNode.addOtherCharacterStates(node.getCharacterState());
            return true;
        }
        return false;
    }

    public boolean optimizeSingleAccessKeyTree(SingleAccessKeyNode parentNode, SingleAccessKeyNode node, boolean isOptimized) throws Exception {
        if (node != null) {
            if (parentNode != null && parentNode.getChildren().size() == 1 && parentNode.getRemainingTaxa().size() == node.getRemainingTaxa().size()) {
                parentNode.getChildren().addAll(node.getChildren());
                parentNode.getChildren().remove(node);
                isOptimized = true;
            }
            int i = 0;
            while (i < node.getChildren().size()) {
                isOptimized = this.optimizeSingleAccessKeyTree(node, node.getChildren().get(i), isOptimized);
                ++i;
            }
        }
        return isOptimized;
    }

    private List<Taxon> getRemainingTaxa(List<Taxon> remainingTaxa, CategoricalCharacter character, State state) throws Exception {
        ArrayList<Taxon> newRemainingTaxa = new ArrayList<Taxon>();
        for (Taxon taxon : remainingTaxa) {
            if (this.dataset.getCodedDescription(taxon).getCharacterDescription(character) != null && !((List)this.dataset.getCodedDescription(taxon).getCharacterDescription(character)).contains(state)) continue;
            newRemainingTaxa.add(taxon);
        }
        return newRemainingTaxa;
    }

    private List<Taxon> getRemainingTaxa(List<Taxon> remainingTaxa, QuantitativeCharacter character, QuantitativeMeasure quantitativeMeasure) throws Exception {
        ArrayList<Taxon> newRemainingTaxa = new ArrayList<Taxon>();
        for (Taxon taxon : remainingTaxa) {
            if (!quantitativeMeasure.isInclude((QuantitativeMeasure)this.dataset.getCodedDescription(taxon).getCharacterDescription(character))) continue;
            newRemainingTaxa.add(taxon);
        }
        return newRemainingTaxa;
    }

    private List<Taxon> getNotDescribedTaxa(List<Taxon> remainingTaxa, CategoricalCharacter character) throws Exception {
        ArrayList<Taxon> notDescribedTaxa = new ArrayList<Taxon>();
        for (Taxon taxon : remainingTaxa) {
            if (this.dataset.getCodedDescription(taxon).getCharacterDescription(character) == null || ((List)this.dataset.getCodedDescription(taxon).getCharacterDescription(character)).size() != 0) continue;
            notDescribedTaxa.add(taxon);
        }
        return notDescribedTaxa;
    }

    private List<Taxon> getNotDescribedTaxa(List<Taxon> remainingTaxa, QuantitativeCharacter character) throws Exception {
        ArrayList<Taxon> notDescribedTaxa = new ArrayList<Taxon>();
        for (Taxon taxon : remainingTaxa) {
            if (this.dataset.getCodedDescription(taxon).getCharacterDescription(character) == null || !((QuantitativeMeasure)this.dataset.getCodedDescription(taxon).getCharacterDescription(character)).isNotSpecified()) continue;
            notDescribedTaxa.add(taxon);
        }
        return notDescribedTaxa;
    }

    private List<QuantitativeMeasure> splitQuantitativeCharacter(ICharacter character, List<Taxon> remainingTaxa) throws Exception {
        int difference;
        ArrayList<QuantitativeMeasure> quantitativeMeasures = new ArrayList<QuantitativeMeasure>();
        QuantitativeMeasure quantitativeMeasure1 = new QuantitativeMeasure();
        QuantitativeMeasure quantitativeMeasure2 = new QuantitativeMeasure();
        List<Double> allValues = this.getAllNumericalValues(character, remainingTaxa);
        Collections.sort(allValues, new Comparator<Double>(){

            @Override
            public int compare(Double val1, Double val2) {
                int result = val1 > val2 ? 1 : (val1 < val2 ? -1 : 0);
                return result;
            }
        });
        Double threshold = null;
        Double bestThreshold = null;
        int differenceMin = difference = allValues.size();
        int taxaBefore = 0;
        int taxaAfter = 0;
        int i = 0;
        while (i < allValues.size() / 2) {
            threshold = allValues.get(i * 2 + 1);
            taxaBefore = 0;
            taxaAfter = 0;
            int j = 0;
            while (j < allValues.size() / 2) {
                if (allValues.get(j * 2 + 1) <= threshold) {
                    ++taxaBefore;
                }
                if (allValues.get(j * 2) >= threshold) {
                    ++taxaAfter;
                }
                ++j;
            }
            difference = Math.abs(taxaBefore - taxaAfter);
            if (difference < differenceMin) {
                differenceMin = difference;
                bestThreshold = threshold;
            }
            ++i;
        }
        if (allValues.size() > 2 && bestThreshold != null) {
            quantitativeMeasure1.setMin(allValues.get(0));
            quantitativeMeasure1.setMax(new Double(bestThreshold));
            quantitativeMeasure1.setMaxInclude(false);
            quantitativeMeasure2.setMin(new Double(bestThreshold));
            quantitativeMeasure2.setMax(allValues.get(allValues.size() - 1));
        }
        quantitativeMeasures.add(quantitativeMeasure1);
        quantitativeMeasures.add(quantitativeMeasure2);
        return quantitativeMeasures;
    }

    private List<Double> getAllNumericalValues(ICharacter character, List<Taxon> remainingTaxa) throws Exception {
        ArrayList<Double> allValues = new ArrayList<Double>();
        for (Taxon taxon : remainingTaxa) {
            if (this.dataset.getCodedDescription(taxon).getCharacterDescription(character) == null || !(this.dataset.getCodedDescription(taxon).getCharacterDescription(character) instanceof QuantitativeMeasure)) continue;
            Double minTmp = ((QuantitativeMeasure)this.dataset.getCodedDescription(taxon).getCharacterDescription(character)).getCalculateMinimum();
            Double maxTmp = ((QuantitativeMeasure)this.dataset.getCodedDescription(taxon).getCharacterDescription(character)).getCalculateMaximum();
            if (minTmp != null) {
                allValues.add(minTmp);
            }
            if (maxTmp == null) continue;
            allValues.add(maxTmp);
        }
        return allValues;
    }

    private Map<ICharacter, Float> charactersScores(List<ICharacter> characters, List<Taxon> remaningTaxa, List<ICharacter> childDependantCharacters, List<ICharacter> alreadyUsedCharacter) throws Exception {
        LinkedHashMap<ICharacter, Float> scoreMap = new LinkedHashMap<ICharacter, Float>();
        for (ICharacter character : characters) {
            if (character.isSupportsCategoricalData()) {
                scoreMap.put(character, Float.valueOf(this.categoricalCharacterScore((CategoricalCharacter)character, remaningTaxa)));
                continue;
            }
            scoreMap.put(character, Float.valueOf(this.quantitativeCharacterScore((QuantitativeCharacter)character, remaningTaxa, alreadyUsedCharacter)));
        }
        this.considerChildCharacterScore(scoreMap, childDependantCharacters);
        return scoreMap;
    }

    private void considerChildCharacterScore(HashMap<ICharacter, Float> scoreMap, List<ICharacter> childDependantCharacters) throws Exception {
        for (ICharacter character : scoreMap.keySet()) {
            if (!character.isSupportsCategoricalData() || character.getChildCharacters().size() <= 0) continue;
            float max = this.getMaxChildScore(scoreMap, character);
            if (!(scoreMap.get(character).floatValue() < max)) continue;
            scoreMap.put(character, Float.valueOf(max));
            childDependantCharacters.add(character);
        }
    }

    private float getMaxChildScore(HashMap<ICharacter, Float> scoreMap, ICharacter character) throws Exception {
        List<ICharacter> characters = character.getAllChildren();
        float max = -1.0f;
        if (character.getParentCharacter() != null && scoreMap.keySet().contains(character.getParentCharacter())) {
            max = -1.0f;
        } else {
            for (ICharacter childCharacter : characters) {
                if (scoreMap.get(childCharacter) == null) continue;
                if (max == -1.0f) {
                    max = scoreMap.get(childCharacter).floatValue();
                }
                if (!(scoreMap.get(childCharacter).floatValue() >= max)) continue;
                max = (float)((double)scoreMap.get(childCharacter).floatValue() + 1.0E-4);
            }
        }
        return max;
    }

    private ICharacter bestCharacter(Map<ICharacter, Float> charactersScore, List<Taxon> remainingTaxa) throws Exception {
        ICharacter bestCharacter;
        block12: {
            float bestScore;
            block11: {
                bestScore = -1.0f;
                bestCharacter = null;
                if (!this.utils.getWeightType().equalsIgnoreCase("contextual")) break block11;
                float bestWeight = -1.0f;
                for (ICharacter character : charactersScore.keySet()) {
                    if (!charactersScore.containsKey(character)) continue;
                    int nWeights = 0;
                    float weightsSum = 0.0f;
                    float averageWeight = 0.0f;
                    for (Taxon taxon : remainingTaxa) {
                        CodedDescription currentCodedDescription = this.dataset.getCodedDescription(taxon);
                        if (currentCodedDescription.getCharacterWeights().containsKey(character)) {
                            ++nWeights;
                            weightsSum += (float)currentCodedDescription.getCharacterWeight(character).intValue();
                            continue;
                        }
                        ++nWeights;
                        weightsSum += 3.0f;
                    }
                    if (nWeights > 0) {
                        averageWeight = weightsSum / (float)nWeights;
                    }
                    if (averageWeight > bestWeight) {
                        bestCharacter = character;
                        bestWeight = averageWeight;
                        bestScore = charactersScore.get(character).floatValue();
                        continue;
                    }
                    if (averageWeight != bestWeight || !(charactersScore.get(character).floatValue() >= bestScore)) continue;
                    bestScore = charactersScore.get(character).floatValue();
                    bestCharacter = character;
                }
                charactersScore.remove(bestCharacter);
                if (!charactersScore.containsValue(Float.valueOf(bestScore)) || !bestCharacter.isSupportsCategoricalData()) break block12;
                int lessTaxaNumber = this.getTaxaNumberForAllStates((CategoricalCharacter)bestCharacter, remainingTaxa);
                for (ICharacter iCharacter : charactersScore.keySet()) {
                    for (Taxon taxon : remainingTaxa) {
                        int currentTaxaNumber;
                        CodedDescription currentCodedDescription = this.dataset.getCodedDescription(taxon);
                        if (currentCodedDescription.getCharacterWeight(iCharacter) == null || (float)currentCodedDescription.getCharacterWeight(iCharacter).intValue() != bestWeight || charactersScore.get(iCharacter).floatValue() != bestScore || !iCharacter.isSupportsCategoricalData() || (currentTaxaNumber = this.getTaxaNumberForAllStates((CategoricalCharacter)iCharacter, remainingTaxa)) >= lessTaxaNumber) continue;
                        bestScore = charactersScore.get(iCharacter).floatValue();
                        bestCharacter = iCharacter;
                        lessTaxaNumber = currentTaxaNumber;
                    }
                }
                break block12;
            }
            float bestWeight = -1.0f;
            for (ICharacter character : charactersScore.keySet()) {
                if (character.getWeight() > bestWeight) {
                    bestCharacter = character;
                    bestWeight = character.getWeight();
                    bestScore = charactersScore.get(character).floatValue();
                    continue;
                }
                if (character.getWeight() != bestWeight || !(charactersScore.get(character).floatValue() >= bestScore)) continue;
                bestScore = charactersScore.get(character).floatValue();
                bestCharacter = character;
            }
            charactersScore.remove(bestCharacter);
            if (charactersScore.containsValue(Float.valueOf(bestScore)) && bestCharacter.isSupportsCategoricalData()) {
                int lessTaxaNumber = this.getTaxaNumberForAllStates((CategoricalCharacter)bestCharacter, remainingTaxa);
                for (ICharacter iCharacter : charactersScore.keySet()) {
                    int currentTaxaNumber;
                    if (iCharacter.getWeight() != bestWeight || charactersScore.get(iCharacter).floatValue() != bestScore || !iCharacter.isSupportsCategoricalData() || (currentTaxaNumber = this.getTaxaNumberForAllStates((CategoricalCharacter)iCharacter, remainingTaxa)) >= lessTaxaNumber) continue;
                    bestScore = charactersScore.get(iCharacter).floatValue();
                    bestCharacter = iCharacter;
                    lessTaxaNumber = currentTaxaNumber;
                }
            }
        }
        return bestCharacter;
    }

    private int getTaxaNumberForAllStates(CategoricalCharacter character, List<Taxon> remainingTaxa) {
        int taxaNumber = 0;
        for (Taxon taxon : remainingTaxa) {
            if (this.dataset.getCodedDescription(taxon).getCharacterDescription(character) == null) continue;
            taxaNumber += ((List)this.dataset.getCodedDescription(taxon).getCharacterDescription(character)).size();
        }
        return taxaNumber;
    }

    private float categoricalCharacterScore(CategoricalCharacter character, List<Taxon> remainingTaxa) throws Exception {
        int cpt = 0;
        float score = 0.0f;
        boolean isAlwaysDescribed = true;
        int i = 0;
        while (i < remainingTaxa.size() - 1) {
            int j = i + 1;
            while (j < remainingTaxa.size()) {
                if (this.dataset.getCodedDescription(remainingTaxa.get(i)) != null && this.dataset.getCodedDescription(remainingTaxa.get(j)) != null && this.dataset.isApplicable(remainingTaxa.get(i), character) && this.dataset.isApplicable(remainingTaxa.get(j), character)) {
                    List statesList1 = (List)this.dataset.getCodedDescription(remainingTaxa.get(i)).getCharacterDescription(character);
                    List statesList2 = (List)this.dataset.getCodedDescription(remainingTaxa.get(j)).getCharacterDescription(character);
                    if (statesList1 != null && statesList1.size() == 0 || statesList2 != null && statesList2.size() == 0) {
                        isAlwaysDescribed = false;
                    }
                    if (statesList1 == null && statesList2 != null && statesList2.size() == 0 || statesList2 == null && statesList1 != null && statesList1.size() == 0) {
                        score += 1.0f;
                    } else if (statesList1 != null && statesList2 != null) {
                        float commonAbsent = 0.0f;
                        float commonPresent = 0.0f;
                        float other = 0.0f;
                        int k = 0;
                        while (k < character.getStates().size()) {
                            State state = character.getStates().get(k);
                            if (statesList1.contains(state)) {
                                if (statesList2.contains(state)) {
                                    commonPresent += 1.0f;
                                } else {
                                    other += 1.0f;
                                }
                            } else if (statesList2.contains(state)) {
                                other += 1.0f;
                            } else {
                                commonAbsent += 1.0f;
                            }
                            ++k;
                        }
                        score += this.applyScoreMethod(commonPresent, commonAbsent, other);
                    }
                    ++cpt;
                }
                ++j;
            }
            ++i;
        }
        if (cpt >= 1) {
            score /= (float)cpt;
        }
        if (isAlwaysDescribed && score > 0.0f) {
            score += 2.0f;
        }
        if (this.utils.isFewStatesCharacterFirst() && score > 0.0f && character.getStates().size() >= 2) {
            float coeff = 1.0f - (float)character.getStates().size() / (float)this.maxNbStatesPerCharacter;
            score += coeff;
        }
        return score;
    }

    private float quantitativeCharacterScore(QuantitativeCharacter character, List<Taxon> remainingTaxa, List<ICharacter> alreadyUsedCharacter) throws Exception {
        int cpt = 0;
        float score = 0.0f;
        boolean isAlwaysDescribed = true;
        List<QuantitativeMeasure> QuantitativeIntervals = this.splitQuantitativeCharacter(character, remainingTaxa);
        int i = 0;
        while (i < remainingTaxa.size() - 1) {
            int j = i + 1;
            while (j < remainingTaxa.size()) {
                if (this.dataset.getCodedDescription(remainingTaxa.get(i)) != null && this.dataset.getCodedDescription(remainingTaxa.get(j)) != null && this.dataset.isApplicable(remainingTaxa.get(i), character) && this.dataset.isApplicable(remainingTaxa.get(j), character)) {
                    float commonAbsent = 0.0f;
                    float commonPresent = 0.0f;
                    float other = 0.0f;
                    QuantitativeMeasure quantitativeMeasure1 = (QuantitativeMeasure)this.dataset.getCodedDescription(remainingTaxa.get(i)).getCharacterDescription(character);
                    QuantitativeMeasure quantitativeMeasure2 = (QuantitativeMeasure)this.dataset.getCodedDescription(remainingTaxa.get(j)).getCharacterDescription(character);
                    if (quantitativeMeasure1 != null && quantitativeMeasure1.isNotSpecified() || quantitativeMeasure2 != null && quantitativeMeasure2.isNotSpecified()) {
                        isAlwaysDescribed = false;
                    }
                    if (quantitativeMeasure1 == null && quantitativeMeasure2 != null && quantitativeMeasure2.isNotSpecified() || quantitativeMeasure2 == null && quantitativeMeasure1 != null && quantitativeMeasure1.isNotSpecified()) {
                        score += 1.0f;
                    } else if (quantitativeMeasure1 != null && quantitativeMeasure2 != null) {
                        if (quantitativeMeasure1.isNotSpecified() && !quantitativeMeasure2.isNotSpecified() || quantitativeMeasure2.isNotSpecified() && !quantitativeMeasure1.isNotSpecified()) {
                            score += 1.0f;
                        } else {
                            for (QuantitativeMeasure quantitativeMeasure : QuantitativeIntervals) {
                                if (quantitativeMeasure.isInclude(quantitativeMeasure1)) {
                                    if (quantitativeMeasure.isInclude(quantitativeMeasure2)) {
                                        commonPresent += 1.0f;
                                        continue;
                                    }
                                    other += 1.0f;
                                    continue;
                                }
                                if (quantitativeMeasure.isInclude(quantitativeMeasure2)) {
                                    other += 1.0f;
                                    continue;
                                }
                                commonAbsent += 1.0f;
                            }
                            score += this.applyScoreMethod(commonPresent, commonAbsent, other);
                        }
                    }
                    ++cpt;
                }
                ++j;
            }
            ++i;
        }
        if (cpt >= 1) {
            score /= (float)cpt;
        }
        if (!alreadyUsedCharacter.contains(character) && isAlwaysDescribed && score > 0.0f) {
            score += 2.0f;
        }
        if (this.utils.isFewStatesCharacterFirst() && score > 0.0f) {
            float coeff = 1.0f - 2.0f / (float)this.maxNbStatesPerCharacter;
            score += coeff;
        }
        return score;
    }

    public static float calculCommonPercentage(double min1, double max1, double min2, double max2) throws Exception {
        double minLowerTmp = 0.0;
        double maxUpperTmp = 0.0;
        double minUpperTmp = 0.0;
        double maxLowerTmp = 0.0;
        float res = 0.0f;
        if (min1 <= min2) {
            minLowerTmp = min1;
            minUpperTmp = min2;
        } else {
            minLowerTmp = min2;
            minUpperTmp = min1;
        }
        if (max1 >= max2) {
            maxUpperTmp = max1;
            maxLowerTmp = max2;
        } else {
            maxUpperTmp = max2;
            maxLowerTmp = max1;
        }
        res = new Double((maxLowerTmp - minUpperTmp) / (maxUpperTmp - minLowerTmp)).floatValue();
        if (res < 0.0f) {
            res = 0.0f;
        }
        return res;
    }

    private int calculateMaxNbStatesPerCharacter() {
        int max = 2;
        for (ICharacter ic : this.dataset.getCharacters()) {
            if (!(ic instanceof CategoricalCharacter) || ((CategoricalCharacter)ic).getStates() == null || max >= ((CategoricalCharacter)ic).getStates().size()) continue;
            max = ((CategoricalCharacter)ic).getStates().size();
        }
        return max;
    }

    private float applyScoreMethod(float commonPresent, float commonAbsent, float other) {
        float out = 0.0f;
        if (this.utils.getScoreMethod().trim().equalsIgnoreCase("sokalAndMichener")) {
            out = 1.0f - (commonPresent + commonAbsent) / (commonPresent + commonAbsent + other);
            out = Utils.roundFloat(out, 3);
        } else if (this.utils.getScoreMethod().trim().equalsIgnoreCase("jaccard")) {
            try {
                out = 1.0f - commonPresent / (commonPresent + other);
                out = Utils.roundFloat(out, 3);
            }
            catch (ArithmeticException a) {
                out = 0.0f;
            }
        } else {
            out = commonPresent == 0.0f && other > 0.0f ? 1.0f : 0.0f;
        }
        return out;
    }

    public SingleAccessKeyTree getSingleAccessKeyTree() {
        return this.singleAccessKeyTree;
    }

    public void setSingleAccessKeyTree(SingleAccessKeyTree singleAccessKeyTree) {
        this.singleAccessKeyTree = singleAccessKeyTree;
    }

    public DataSet getDataSet() {
        return this.dataset;
    }

    public void setDataSet(DataSet dataSet) {
        this.dataset = dataSet;
    }

    public int getMaxNumStatesPerCharacter() {
        return this.maxNbStatesPerCharacter;
    }

    public void setMaxNumStatesPerCharacter(int maxNumStatesPerCharacter) {
        this.maxNbStatesPerCharacter = maxNumStatesPerCharacter;
    }
}

