/*
 * Decompiled with CFR 0.152.
 */
package main.java.IO;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import main.java.model.CategoricalCharacter;
import main.java.model.CodedDescription;
import main.java.model.DataSet;
import main.java.model.ICharacter;
import main.java.model.QuantitativeCharacter;
import main.java.model.QuantitativeMeasure;
import main.java.model.State;
import main.java.model.Taxon;
import main.java.utils.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SDDContentHandler
implements ContentHandler {
    private Locator locator = null;
    private boolean inDataset = false;
    private boolean inRepresentation = false;
    private boolean inConceptStates = false;
    private boolean inStates = false;
    private boolean inStateDefinition = false;
    private boolean inStatesReference = false;
    private boolean inNodes = false;
    private boolean inCharNode = false;
    private boolean inDependencyRules = false;
    private boolean inInapplicableIf = false;
    private boolean inOnlyApplicableIf = false;
    private boolean inCodedDescriptions = false;
    private boolean inCodedDescription = false;
    private boolean inScope = false;
    private boolean inSummaryData = false;
    private boolean inCategorical = false;
    private boolean inQuantitative = false;
    private boolean inMeasurementUnit = false;
    private boolean inCategoricalCharacter = false;
    private boolean inQuantitativeCharacter = false;
    private boolean inCharacterTree = false;
    private boolean inCharacters = false;
    private boolean inRatings = false;
    private boolean inMediaObject = false;
    private boolean dataUnavailableFlag = false;
    private boolean isImageType = false;
    private boolean isDataSetLabel = true;
    private boolean isFirstDataset = true;
    private boolean isFirstCharacterTree = true;
    private StringBuffer buffer = null;
    private DataSet dataSet = new DataSet();
    private Utils utils = null;
    private CategoricalCharacter currentCategoricalCharacter = null;
    private QuantitativeCharacter currentQuantitativeCharacter = null;
    private State currentState = null;
    private CodedDescription currentCodedDescription = null;
    private Taxon currentTaxon = null;
    private ICharacter currentCodedDescriptionCharacter = null;
    private List<State> currentStatesList = null;
    private QuantitativeMeasure currentQuantitativeMeasure = null;
    private ICharacter currentCharacterNode = null;
    List<State> currentInapplicableState = null;
    List<State> currentOnlyApplicableState = null;
    private String mediaObjectId = null;
    private Map<ICharacter, Integer> ratingsCounter = null;

    public SDDContentHandler(Utils utils) {
        this.utils = utils;
        this.ratingsCounter = new HashMap<ICharacter, Integer>();
    }

    @Override
    public void startElement(String nameSpaceURI, String localName, String rawName, Attributes attributs) throws SAXException {
        if (this.isFirstDataset) {
            if (this.inDataset && !localName.equals("Representation") && !localName.equals("Label")) {
                this.isDataSetLabel = false;
            }
            if (localName.equals("Dataset")) {
                this.inDataset = true;
            } else if (localName.equals("Representation") && this.inDataset) {
                this.inRepresentation = true;
            } else if (localName.equals("Label") && this.inDataset) {
                this.buffer = new StringBuffer();
            } else if (localName.equals("ConceptStates")) {
                this.inConceptStates = true;
            } else if (!localName.equals("StateDefinition") || !this.inConceptStates) {
                if (localName.equals("Characters")) {
                    this.inCharacters = true;
                } else if (localName.equals("CategoricalCharacter") && this.inCharacters) {
                    this.inCategoricalCharacter = true;
                    this.currentCategoricalCharacter = new CategoricalCharacter();
                    this.currentCategoricalCharacter.setId(attributs.getValue("id"));
                } else if (localName.equals("QuantitativeCharacter") && this.inCharacters) {
                    this.inQuantitativeCharacter = true;
                    this.currentQuantitativeCharacter = new QuantitativeCharacter();
                    this.currentQuantitativeCharacter.setId(attributs.getValue("id"));
                } else if (localName.equals("States")) {
                    this.inStates = true;
                } else if (localName.equals("StateDefinition") && this.inStates) {
                    this.inStateDefinition = true;
                    this.currentState = new State();
                    this.currentState.setId(attributs.getValue("id"));
                } else if (localName.equals("MediaObject") && this.inStateDefinition && this.inRepresentation && this.inStates) {
                    if (attributs.getValue("ref") != null && this.currentState != null) {
                        this.currentState.getMediaObjectKeys().add(attributs.getValue("ref"));
                    }
                } else if (localName.equals("StateReference") && this.inStates) {
                    this.inStatesReference = true;
                } else if (!localName.equals("ConceptState") || !this.inStatesReference) {
                    if (localName.equals("CharacterTree")) {
                        if (this.isFirstCharacterTree) {
                            this.inCharacterTree = true;
                        }
                    } else if (localName.equals("Nodes")) {
                        this.inNodes = true;
                    } else if (localName.equals("CharNode") && this.inNodes) {
                        this.inCharNode = true;
                        this.currentInapplicableState = new ArrayList<State>();
                        this.currentOnlyApplicableState = new ArrayList<State>();
                    } else if (localName.equals("DependencyRules") && this.inCharNode) {
                        this.inDependencyRules = true;
                    } else if (localName.equals("InapplicableIf") && this.inDependencyRules) {
                        this.inInapplicableIf = true;
                    } else if (localName.equals("OnlyApplicableIf") && this.inDependencyRules) {
                        this.inOnlyApplicableIf = true;
                    } else if (localName.equals("State") && this.inInapplicableIf && this.inCharacterTree && this.isFirstCharacterTree) {
                        State state = this.dataSet.getStateById(attributs.getValue("ref"));
                        this.currentInapplicableState.add(state);
                    } else if (localName.equals("State") && this.inOnlyApplicableIf && this.inCharacterTree && this.isFirstCharacterTree) {
                        State state = this.dataSet.getStateById(attributs.getValue("ref"));
                        this.currentOnlyApplicableState.add(state);
                    } else if (localName.equals("Character") && this.inCharNode && this.inCharacterTree && this.isFirstCharacterTree) {
                        this.currentCharacterNode = this.dataSet.getCharacterById(attributs.getValue("ref"));
                    } else if (localName.equals("CodedDescriptions")) {
                        this.inCodedDescriptions = true;
                    } else if (localName.equals("CodedDescription") && this.inCodedDescriptions) {
                        this.inCodedDescription = true;
                        this.currentCodedDescription = new CodedDescription();
                        this.currentCodedDescription.setId(attributs.getValue("id"));
                        this.currentTaxon = new Taxon();
                    } else if (localName.equals("MediaObject") && this.inCodedDescription && this.inCodedDescriptions) {
                        if (attributs.getValue("ref") != null && this.currentTaxon != null) {
                            this.currentTaxon.getMediaObjectKeys().add(attributs.getValue("ref"));
                        }
                    } else if (localName.equals("Scope")) {
                        this.inScope = true;
                    } else if (!localName.equals("TaxonName") || !this.inScope) {
                        if (localName.equals("SummaryData")) {
                            this.inSummaryData = true;
                        } else if (localName.equals("Categorical") && this.inSummaryData) {
                            this.inCategorical = true;
                            this.currentCodedDescriptionCharacter = this.dataSet.getCharacterById(attributs.getValue("ref"));
                            this.currentStatesList = new ArrayList<State>();
                        } else if (localName.equals("State") && this.inCategorical) {
                            if (this.currentStatesList != null) {
                                this.currentStatesList.add(this.dataSet.getStateById(attributs.getValue("ref")));
                            }
                        } else if (localName.equals("Status") && this.inCategorical) {
                            if (attributs.getValue("code") != null && attributs.getValue("code").equals("DataUnavailable")) {
                                this.dataUnavailableFlag = true;
                            }
                        } else if (localName.equals("Quantitative") && this.inSummaryData) {
                            this.inQuantitative = true;
                            this.currentCodedDescriptionCharacter = this.dataSet.getCharacterById(attributs.getValue("ref"));
                            this.currentQuantitativeMeasure = new QuantitativeMeasure();
                        } else if (localName.equals("Measure") && this.inQuantitative) {
                            if (this.currentQuantitativeMeasure != null) {
                                if (attributs.getValue("type").equals("Min")) {
                                    this.currentQuantitativeMeasure.setMin(Utils.convertStringToDouble(attributs.getValue("value")));
                                } else if (attributs.getValue("type").equals("Max")) {
                                    this.currentQuantitativeMeasure.setMax(Utils.convertStringToDouble(attributs.getValue("value")));
                                } else if (attributs.getValue("type").equals("Mean")) {
                                    this.currentQuantitativeMeasure.setMean(Utils.convertStringToDouble(attributs.getValue("value")));
                                } else if (attributs.getValue("type").equals("SD")) {
                                    this.currentQuantitativeMeasure.setSD(Utils.convertStringToDouble(attributs.getValue("value")));
                                } else if (attributs.getValue("type").equals("UMethLower")) {
                                    this.currentQuantitativeMeasure.setUMethLower(Utils.convertStringToDouble(attributs.getValue("value")));
                                } else if (attributs.getValue("type").equals("UMethUpper")) {
                                    this.currentQuantitativeMeasure.setUMethUpper(Utils.convertStringToDouble(attributs.getValue("value")));
                                }
                            }
                        } else if (localName.equals("Status") && this.inCategorical) {
                            if (attributs.getValue("code") != null && attributs.getValue("code").equals("DataUnavailable")) {
                                this.dataUnavailableFlag = true;
                            }
                        } else if (localName.equals("MeasurementUnit")) {
                            this.inMeasurementUnit = true;
                        } else if (localName.equals("Ratings")) {
                            this.inRatings = true;
                        } else if (localName.equals("Rating") && this.inRatings) {
                            if (attributs.getValue("context").equals(this.utils.getWeightContext())) {
                                int currentRating = Utils.ratings.indexOf(attributs.getValue("rating")) + 1;
                                if (this.currentCodedDescriptionCharacter != null) {
                                    if (this.ratingsCounter.get(this.currentCodedDescriptionCharacter) == null) {
                                        this.ratingsCounter.put(this.currentCodedDescriptionCharacter, 0);
                                        this.currentCodedDescriptionCharacter.setWeight(0.0f);
                                    }
                                    this.currentCodedDescriptionCharacter.setWeight(this.currentCodedDescriptionCharacter.getWeight() + (float)currentRating);
                                    this.ratingsCounter.put(this.currentCodedDescriptionCharacter, this.ratingsCounter.get(this.currentCodedDescriptionCharacter) + 1);
                                    if (this.utils.getWeightType().equalsIgnoreCase("contextual")) {
                                        this.currentCodedDescription.addCharacterWeight(this.currentCodedDescriptionCharacter, currentRating);
                                    }
                                }
                            }
                        } else if (localName.equals("MediaObject")) {
                            this.inMediaObject = true;
                            this.mediaObjectId = attributs.getValue("id") != null ? attributs.getValue("id") : null;
                        } else if (localName.equals("Type") && this.inMediaObject) {
                            this.buffer = new StringBuffer();
                        } else if (localName.equals("Source") && this.inMediaObject && this.mediaObjectId != null && this.isImageType && attributs.getValue("href") != null) {
                            this.dataSet.getMediaObjects().put(this.mediaObjectId, attributs.getValue("href"));
                        }
                    }
                }
            }
        }
    }

    @Override
    public void endElement(String nameSpaceURI, String localName, String rawName) throws SAXException {
        if (this.isFirstDataset) {
            if (localName.equals("Dataset")) {
                this.inDataset = false;
                this.isFirstDataset = false;
                for (Taxon taxon : this.dataSet.getCodedDescriptions().keySet()) {
                    for (ICharacter character : this.dataSet.getCharacters()) {
                        if (this.dataSet.getCodedDescriptions().get(taxon).getCharacterDescription(character) == null) {
                            if (character.isSupportsCategoricalData()) {
                                this.dataSet.getCodedDescriptions().get(taxon).addCharacterDescription(character, new ArrayList());
                                continue;
                            }
                            this.dataSet.getCodedDescriptions().get(taxon).addCharacterDescription(character, new QuantitativeMeasure());
                            continue;
                        }
                        if (!(this.dataSet.getCodedDescriptions().get(taxon).getCharacterDescription(character) instanceof String) || !((String)this.dataSet.getCodedDescriptions().get(taxon).getCharacterDescription(character)).equals("unknownData")) continue;
                        this.dataSet.getCodedDescriptions().get(taxon).addCharacterDescription(character, null);
                    }
                }
                for (ICharacter character : this.dataSet.getCharacters()) {
                    if (this.ratingsCounter.get(character) == null) continue;
                    character.setWeight(character.getWeight() / (float)this.ratingsCounter.get(character).intValue());
                }
            } else if (localName.equals("Representation") && this.inDataset) {
                this.inRepresentation = false;
            } else if (localName.equals("Label") && this.inRepresentation && this.inDataset) {
                if (this.inCodedDescription) {
                    this.currentTaxon.setName(this.buffer.toString());
                } else if (this.inCategoricalCharacter && this.inStateDefinition) {
                    this.currentState.setName(this.buffer.toString());
                } else if (this.inCategoricalCharacter) {
                    this.currentCategoricalCharacter.setName(this.buffer.toString());
                } else if (this.inQuantitativeCharacter) {
                    this.currentQuantitativeCharacter.setName(this.buffer.toString());
                } else if (this.isDataSetLabel) {
                    this.dataSet.setLabel(this.buffer.toString());
                    this.isDataSetLabel = false;
                }
            } else if (localName.equals("Label") && this.inMeasurementUnit && this.inDataset) {
                if (this.currentQuantitativeCharacter != null) {
                    this.currentQuantitativeCharacter.setMeasurementUnit(this.buffer.toString());
                }
            } else if (localName.equals("ConceptStates")) {
                this.inConceptStates = false;
            } else if (!localName.equals("StateDefinition") || !this.inConceptStates) {
                if (localName.equals("Characters")) {
                    this.inCharacters = false;
                } else if (localName.equals("CategoricalCharacter") && this.inCharacters) {
                    this.inCategoricalCharacter = false;
                    this.dataSet.getCharacters().add(this.currentCategoricalCharacter);
                    this.currentCategoricalCharacter = null;
                } else if (localName.equals("QuantitativeCharacter") && this.inCharacters) {
                    this.inQuantitativeCharacter = false;
                    this.dataSet.getCharacters().add(this.currentQuantitativeCharacter);
                    this.currentQuantitativeCharacter = null;
                } else if (localName.equals("States")) {
                    this.inStates = false;
                } else if (localName.equals("StateDefinition") && this.inStates) {
                    this.inStateDefinition = false;
                    this.currentCategoricalCharacter.getStates().add(this.currentState);
                    this.currentState = null;
                } else if (localName.equals("StateReference") && this.inStates) {
                    this.inStatesReference = false;
                } else if (!localName.equals("ConceptState") || !this.inStatesReference) {
                    if (localName.equals("CharacterTree")) {
                        this.isFirstCharacterTree = false;
                        this.inCharacterTree = false;
                    } else if (localName.equals("Nodes")) {
                        this.inNodes = false;
                    } else if (localName.equals("CharNode") && this.inNodes) {
                        ICharacter character;
                        this.inCharNode = false;
                        if (this.currentInapplicableState.size() > 0) {
                            this.currentCharacterNode.setParentCharacter(this.dataSet.getCharacterByState(this.currentInapplicableState.get(0)));
                            this.currentCharacterNode.getInapplicableStates().addAll(this.currentInapplicableState);
                        } else if (this.currentOnlyApplicableState.size() > 0 && (character = this.dataSet.getCharacterByState(this.currentOnlyApplicableState.get(0))) != null && character instanceof CategoricalCharacter) {
                            this.currentCharacterNode.setParentCharacter(character);
                            ArrayList<State> tempList = new ArrayList<State>(((CategoricalCharacter)character).getStates());
                            tempList.removeAll(this.currentOnlyApplicableState);
                            this.currentCharacterNode.getInapplicableStates().addAll(tempList);
                        }
                        this.currentInapplicableState = null;
                        this.currentOnlyApplicableState = null;
                        this.currentCharacterNode = null;
                    } else if (localName.equals("DependencyRules") && this.inCharNode) {
                        this.inDependencyRules = false;
                    } else if (localName.equals("InapplicableIf") && this.inDependencyRules) {
                        this.inInapplicableIf = false;
                    } else if (localName.equals("OnlyApplicableIf") && this.inDependencyRules) {
                        this.inOnlyApplicableIf = false;
                    } else if (!(localName.equals("State") && this.inInapplicableIf && this.inCharacterTree && this.isFirstCharacterTree || localName.equals("State") && this.inOnlyApplicableIf && this.inCharacterTree && this.isFirstCharacterTree || localName.equals("Character") && this.inCharNode && this.inCharacterTree && this.isFirstCharacterTree)) {
                        if (localName.equals("CodedDescriptions")) {
                            this.inCodedDescriptions = false;
                        } else if (localName.equals("CodedDescription") && this.inCodedDescriptions) {
                            this.inCodedDescription = false;
                            this.dataSet.addCodedDescription(this.currentTaxon, this.currentCodedDescription);
                            this.currentTaxon = null;
                        } else if (localName.equals("Scope")) {
                            this.inScope = false;
                        } else if (!localName.equals("TaxonName") || !this.inScope) {
                            if (localName.equals("SummaryData")) {
                                this.inSummaryData = false;
                            } else if (localName.equals("Categorical") && this.inSummaryData) {
                                this.inCategorical = false;
                                if (this.dataUnavailableFlag) {
                                    this.currentCodedDescription.addCharacterDescription(this.currentCodedDescriptionCharacter, "unknownData");
                                } else {
                                    this.currentCodedDescription.addCharacterDescription(this.currentCodedDescriptionCharacter, this.currentStatesList);
                                }
                                this.currentCodedDescriptionCharacter = null;
                                this.currentStatesList = null;
                                this.dataUnavailableFlag = false;
                            } else if (localName.equals("Quantitative") && this.inSummaryData) {
                                this.inQuantitative = false;
                                if (this.dataUnavailableFlag) {
                                    this.currentCodedDescription.addCharacterDescription(this.currentCodedDescriptionCharacter, "unknownData");
                                } else {
                                    this.currentCodedDescription.addCharacterDescription(this.currentCodedDescriptionCharacter, this.currentQuantitativeMeasure);
                                }
                                this.currentCodedDescriptionCharacter = null;
                                this.currentQuantitativeMeasure = null;
                                this.dataUnavailableFlag = false;
                            } else if (!localName.equals("Measure") || !this.inQuantitative) {
                                if (localName.equals("MeasurementUnit")) {
                                    this.inMeasurementUnit = false;
                                } else if (localName.equals("Ratings")) {
                                    this.inRatings = false;
                                } else if (localName.equals("MediaObject")) {
                                    this.inMediaObject = false;
                                    this.isImageType = false;
                                    this.mediaObjectId = null;
                                } else if (localName.equals("Type") && this.inMediaObject && this.mediaObjectId != null) {
                                    this.isImageType = this.buffer != null && this.buffer.toString().equalsIgnoreCase("image");
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String data = new String(ch, start, length);
        data = data.replaceAll("\t", " ");
        data = data.replaceAll("\n", " ");
        data = data.replaceAll("[\\s]+", " ");
        if (this.buffer != null) {
            this.buffer.append(data);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
    }
}

