/*
 * Decompiled with CFR 0.152.
 */
package main.java.IO;

import com.itextpdf.text.DocListener;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.html.simpleparser.HTMLWorker;
import com.itextpdf.text.html.simpleparser.StyleSheet;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.Adler32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import main.java.model.DataSet;
import main.java.model.QuantitativeCharacter;
import main.java.model.QuantitativeMeasure;
import main.java.model.SingleAccessKeyNode;
import main.java.model.SingleAccessKeyTree;
import main.java.model.State;
import main.java.model.Taxon;
import main.java.utils.Utils;

public abstract class SingleAccessKeyTreeDumper {
    public static File dumpSddFile(String header, SingleAccessKeyTree tree2dump) throws IOException {
        String path = String.valueOf(Utils.getBundleConfOverridableElement("generatedKeyFiles.prefix")) + Utils.getBundleConfOverridableElement("generatedKeyFiles.folder");
        File sddFile = File.createTempFile("key_", ".sdd", new File(path));
        FileOutputStream fileOutputStream = new FileOutputStream(sddFile);
        fileOutputStream.write(new byte[]{-17, -69, -65});
        BufferedWriter sddFileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"));
        sddFileWriter.append(SingleAccessKeyTreeDumper.generateSddString(tree2dump));
        sddFileWriter.close();
        return sddFile;
    }

    private static String generateSddString(SingleAccessKeyTree tree2dump) {
        StringBuffer output = new StringBuffer();
        String lineSeparator = System.getProperty("line.separator");
        output.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + lineSeparator);
        output.append("<Datasets xmlns=\"http://rs.tdwg.org/UBIF/2006/\" ");
        output.append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://rs.tdwg.org/UBIF/2006/ http://rs.tdwg.org/UBIF/2006/Schema/1.1/SDD.xsd\">" + lineSeparator);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        String generationDate = dateFormat.format(new Date());
        output.append("<TechnicalMetadata created=\"" + generationDate + "\">" + lineSeparator);
        output.append("<Generator name=\"Identification Key generation WebService\" ");
        output.append("notes=\"This software is developed and distributed by LIS - Laboratoire Informatique et Syst\u00e9matique (LIS) - Universit\u00e9 Pierre et Marie Curie - Paris VI - within the ViBRANT project\" version=\"1.1\"/>" + lineSeparator);
        output.append("</TechnicalMetadata>" + lineSeparator);
        output.append("<Dataset xml:lang=\"en\">" + lineSeparator);
        output.append("<Representation>" + lineSeparator);
        output.append("<Label>Identification key</Label>" + lineSeparator);
        output.append("</Representation>" + lineSeparator);
        DataSet originalDataSet = tree2dump.getDataSet();
        output.append("<TaxonNames>" + lineSeparator);
        int taxonIDint = 1;
        for (Taxon t : originalDataSet.getTaxa()) {
            String taxonID = "t" + taxonIDint;
            ++taxonIDint;
            t.setId(taxonID);
            output.append("<TaxonName id=\"" + taxonID + "\">" + lineSeparator);
            output.append("<Representation>" + lineSeparator);
            output.append("<Label>" + t.getName().replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;") + "</Label>" + lineSeparator);
            for (String mediaObjectKey : t.getMediaObjectKeys()) {
                output.append("<MediaObject ref=\"" + mediaObjectKey + "\"/>" + lineSeparator);
            }
            output.append("</Representation>" + lineSeparator);
            output.append("</TaxonName>" + lineSeparator);
        }
        output.append("</TaxonNames>" + lineSeparator);
        output.append("<IdentificationKeys>" + lineSeparator);
        SingleAccessKeyTreeDumper.multipleTraversalToSddString(tree2dump.getRoot(), output, lineSeparator, tree2dump);
        output.append("</IdentificationKeys>" + lineSeparator);
        if (originalDataSet.getMediaObjects().keySet().size() > 0) {
            output.append("<MediaObjects>" + lineSeparator);
            for (String mediaObjectKey : originalDataSet.getMediaObjects().keySet()) {
                output.append("<MediaObject id=\"" + mediaObjectKey + "\">" + lineSeparator);
                output.append("<Representation>" + lineSeparator);
                output.append("<Label>");
                output.append(mediaObjectKey);
                output.append("</Label>" + lineSeparator);
                output.append("</Representation>" + lineSeparator);
                output.append("<Type>Image</Type>" + lineSeparator);
                output.append("<Source href=\"" + originalDataSet.getMediaObject(mediaObjectKey) + "\"/>" + lineSeparator);
                output.append("</MediaObject>" + lineSeparator);
            }
            output.append("</MediaObjects>" + lineSeparator);
        }
        output.append("</Dataset>" + lineSeparator);
        output.append("</Datasets>");
        return output.toString();
    }

    private static void multipleTraversalToSddString(SingleAccessKeyNode rootNode, StringBuffer output, String lineSeparator, SingleAccessKeyTree tree2dump) {
        HashMap<SingleAccessKeyNode, Integer> nodeBreadthFirstIterationMap = new HashMap<SingleAccessKeyNode, Integer>();
        int counter = 1;
        SingleAccessKeyTreeDumper.iterativeBreadthFirst(rootNode, nodeBreadthFirstIterationMap, counter);
        HashMap<Integer, Integer> nodeChildParentNumberingMap = new HashMap<Integer, Integer>();
        ArrayList<Integer> rootNodeChildrenIntegerList = new ArrayList<Integer>();
        SingleAccessKeyTreeDumper.recursiveDepthFirstIntegerIndex(rootNode, nodeBreadthFirstIterationMap, nodeChildParentNumberingMap, rootNodeChildrenIntegerList);
        LinkedList<SingleAccessKeyNode> queue = new LinkedList<SingleAccessKeyNode>();
        ArrayList<SingleAccessKeyNode> visitedNodes = new ArrayList<SingleAccessKeyNode>();
        counter = 1;
        int currentParentNumber = -1;
        queue.add(rootNode);
        ++counter;
        visitedNodes.add(rootNode);
        output.append("<IdentificationKey>" + lineSeparator);
        output.append("<Representation>" + lineSeparator);
        output.append("<Label>" + tree2dump.getLabel() + "</Label>" + lineSeparator);
        output.append("</Representation>" + lineSeparator);
        while (!queue.isEmpty()) {
            SingleAccessKeyNode node = (SingleAccessKeyNode)queue.remove();
            SingleAccessKeyNode child = null;
            while (Utils.exclusion(node.getChildren(), visitedNodes).size() > 0 && (child = (SingleAccessKeyNode)Utils.exclusion(node.getChildren(), visitedNodes).get(0)) != null) {
                visitedNodes.add(child);
                if (nodeChildParentNumberingMap.get(new Integer(counter)) != currentParentNumber) {
                    currentParentNumber = nodeChildParentNumberingMap.get(new Integer(counter));
                }
                if (counter == 2) {
                    output.append("<Question>" + lineSeparator);
                    output.append("<Text>" + SingleAccessKeyTreeDumper.escapeHTMLSpecialCharacters(child.getCharacter().getName()) + "</Text>" + lineSeparator);
                    output.append("</Question>" + lineSeparator);
                    output.append("<Leads>" + lineSeparator);
                }
                String mediaObjectsTags = "";
                if (child.getCharacter().isSupportsCategoricalData()) {
                    for (String mediaObjectKey : ((State)child.getCharacterState()).getMediaObjectKeys()) {
                        mediaObjectsTags = String.valueOf(mediaObjectsTags) + "<MediaObject ref=\"" + mediaObjectKey + "\"/>" + lineSeparator;
                    }
                }
                if (rootNodeChildrenIntegerList.contains(new Integer(counter))) {
                    if (child.hasChild()) {
                        output.append("<Lead id=\"lead" + (counter - 1) + "\">" + lineSeparator);
                        output.append("<Statement>" + child.getStringStates().replace(">", "&gt;").replace("<", "&lt;").replace("&", "&amp;"));
                        output.append("</Statement>" + lineSeparator);
                        output.append(mediaObjectsTags);
                        output.append("<Question>" + lineSeparator);
                        output.append("<Text>" + child.getChildren().get(0).getCharacter().getName().replace(">", "&gt;").replace("<", "&lt;").replace("&", "&amp;") + "</Text>" + lineSeparator);
                        output.append("</Question>" + lineSeparator);
                        output.append("</Lead>" + lineSeparator);
                    } else {
                        output.append("<Lead id=\"nil0\">" + lineSeparator);
                        output.append("<Statement>nil</Statement>" + lineSeparator);
                        output.append(mediaObjectsTags);
                        output.append("</Lead>" + lineSeparator);
                        for (Taxon t : child.getRemainingTaxa()) {
                            output.append("<Lead>" + lineSeparator);
                            output.append("<Parent ref=\"nil0\" />" + lineSeparator);
                            output.append("<Statement>" + child.getStringStates().replace(">", "&gt;").replace("<", "&lt;").replace("&", "&amp;"));
                            output.append("</Statement>" + lineSeparator);
                            output.append("<TaxonName ref=\"" + t.getId() + "\"/>" + lineSeparator);
                            output.append("</Lead>" + lineSeparator);
                        }
                    }
                } else if (child.hasChild()) {
                    output.append("<Lead id=\"lead" + (counter - 1) + "\">" + lineSeparator);
                    output.append("<Parent ref=\"lead" + (currentParentNumber - 1) + "\"/>" + lineSeparator);
                    output.append("<Statement>" + child.getStringStates().replace(">", "&gt;").replace("<", "&lt;").replace("&", "&amp;"));
                    output.append("</Statement>" + lineSeparator);
                    output.append(mediaObjectsTags);
                    output.append("<Question>" + lineSeparator);
                    output.append("<Text>" + child.getChildren().get(0).getCharacter().getName().replace(">", "&gt;").replace("<", "&lt;").replace("&", "&amp;") + "</Text>" + lineSeparator);
                    output.append("</Question>" + lineSeparator);
                    output.append("</Lead>" + lineSeparator);
                } else {
                    output.append("<Lead id=\"nil" + (counter - 1) + "\">" + lineSeparator);
                    output.append("<Parent ref=\"lead" + (currentParentNumber - 1) + "\"/>" + lineSeparator);
                    output.append("<Statement>nil</Statement>" + lineSeparator);
                    output.append(mediaObjectsTags);
                    output.append("</Lead>" + lineSeparator);
                    for (Taxon t : child.getRemainingTaxa()) {
                        output.append("<Lead>" + lineSeparator);
                        output.append("<Parent ref=\"nil" + (counter - 1) + "\" />" + lineSeparator);
                        output.append("<Statement>" + child.getStringStates().replace(">", "&gt;").replace("<", "&lt;").replace("&", "&amp;"));
                        output.append("</Statement>" + lineSeparator);
                        output.append("<TaxonName ref=\"" + t.getId() + "\"/>" + lineSeparator);
                        output.append("</Lead>" + lineSeparator);
                    }
                }
                queue.add(child);
                ++counter;
            }
        }
        output.append("</Leads>" + lineSeparator);
        output.append("</IdentificationKey>" + lineSeparator);
    }

    public static File dumpTxtFile(String header, SingleAccessKeyTree tree2dump, boolean showStatistics) throws IOException {
        String path = String.valueOf(Utils.getBundleConfOverridableElement("generatedKeyFiles.prefix")) + Utils.getBundleConfOverridableElement("generatedKeyFiles.folder");
        File txtFile = File.createTempFile("key_", ".txt", new File(path));
        FileOutputStream fileOutputStream = new FileOutputStream(txtFile);
        fileOutputStream.write(new byte[]{-17, -69, -65});
        BufferedWriter txtFileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"));
        txtFileWriter.append(header);
        txtFileWriter.append(SingleAccessKeyTreeDumper.generateTreeString(tree2dump));
        if (showStatistics) {
            tree2dump.gatherTaxonPathStatistics();
            txtFileWriter.append(SingleAccessKeyTreeDumper.outputTaxonPathStatisticsString(tree2dump));
        }
        txtFileWriter.close();
        return txtFile;
    }

    private static String generateTreeString(SingleAccessKeyTree tree2dump) {
        StringBuffer output = new StringBuffer();
        SingleAccessKeyTreeDumper.recursiveToString(tree2dump.getRoot(), output, System.getProperty("line.separator"), 0, 0, tree2dump);
        return output.toString();
    }

    private static void recursiveToString(SingleAccessKeyNode node, StringBuffer output, String tabulations, int firstNumbering, int secondNumbering, SingleAccessKeyTree tree2dump) {
        if (node != null && node.getCharacter() != null && node.getCharacterState() != null) {
            if (node.getCharacterState() instanceof QuantitativeMeasure) {
                output.append(String.valueOf(tabulations) + firstNumbering + "." + secondNumbering + ") " + node.getCharacter().getName() + " | " + ((QuantitativeMeasure)node.getCharacterState()).toStringInterval(((QuantitativeCharacter)node.getCharacter()).getMeasurementUnit()));
            } else {
                output.append(String.valueOf(tabulations) + firstNumbering + "." + secondNumbering + ") " + node.getCharacter().getName() + " | " + node.getStringStates());
            }
            output.append(tree2dump.nodeDescriptionAnalysis(node));
            if (node.getChildren().size() == 0) {
                output.append(" -> ");
                boolean firstLoop = true;
                for (Taxon taxon : node.getRemainingTaxa()) {
                    if (!firstLoop) {
                        output.append(", ");
                    }
                    output.append(taxon.getName());
                    firstLoop = false;
                }
            } else {
                output.append(" (items=" + node.getRemainingTaxa().size() + ")");
            }
            tabulations = String.valueOf(tabulations) + "\t";
        }
        ++firstNumbering;
        secondNumbering = 0;
        for (SingleAccessKeyNode childNode : node.getChildren()) {
            SingleAccessKeyTreeDumper.recursiveToString(childNode, output, tabulations, firstNumbering, ++secondNumbering, tree2dump);
        }
    }

    public static File dumpFlatTxtFile(String header, SingleAccessKeyTree tree2dump, boolean showStatistics) throws IOException {
        String path = String.valueOf(Utils.getBundleConfOverridableElement("generatedKeyFiles.prefix")) + Utils.getBundleConfOverridableElement("generatedKeyFiles.folder");
        File txtFile = File.createTempFile("key_", ".txt", new File(path));
        FileOutputStream fileOutputStream = new FileOutputStream(txtFile);
        fileOutputStream.write(new byte[]{-17, -69, -65});
        BufferedWriter txtFileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"));
        txtFileWriter.append(header);
        txtFileWriter.append(SingleAccessKeyTreeDumper.generateFlatString(tree2dump));
        if (showStatistics) {
            tree2dump.gatherTaxonPathStatistics();
            txtFileWriter.append(SingleAccessKeyTreeDumper.outputTaxonPathStatisticsString(tree2dump));
        }
        txtFileWriter.close();
        return txtFile;
    }

    private static String generateFlatString(SingleAccessKeyTree tree2dump) {
        StringBuffer output = new StringBuffer();
        SingleAccessKeyTreeDumper.multipleTraversalToString(tree2dump.getRoot(), output, System.getProperty("line.separator"), tree2dump);
        return output.toString();
    }

    private static void multipleTraversalToString(SingleAccessKeyNode rootNode, StringBuffer output, String lineSeparator, SingleAccessKeyTree tree2dump) {
        HashMap<SingleAccessKeyNode, Integer> nodeBreadthFirstIterationMap = new HashMap<SingleAccessKeyNode, Integer>();
        int counter = 1;
        SingleAccessKeyTreeDumper.iterativeBreadthFirstSkipChildlessNodes(rootNode, nodeBreadthFirstIterationMap, counter);
        HashMap<SingleAccessKeyNode, Integer> nodeChildParentNumberingMap = new HashMap<SingleAccessKeyNode, Integer>();
        SingleAccessKeyTreeDumper.recursiveDepthFirstNodeIndex(rootNode, nodeBreadthFirstIterationMap, nodeChildParentNumberingMap);
        LinkedList<SingleAccessKeyNode> queue = new LinkedList<SingleAccessKeyNode>();
        ArrayList<SingleAccessKeyNode> visitedNodes = new ArrayList<SingleAccessKeyNode>();
        queue.clear();
        visitedNodes.clear();
        counter = 1;
        int currentParentNumber = -1;
        queue.add(rootNode);
        ++counter;
        visitedNodes.add(rootNode);
        while (!queue.isEmpty()) {
            SingleAccessKeyNode node = (SingleAccessKeyNode)queue.remove();
            SingleAccessKeyNode child = null;
            while (Utils.exclusion(node.getChildren(), visitedNodes).size() > 0 && (child = (SingleAccessKeyNode)Utils.exclusion(node.getChildren(), visitedNodes).get(0)) != null) {
                visitedNodes.add(child);
                if (nodeChildParentNumberingMap.get(child) != currentParentNumber) {
                    currentParentNumber = nodeChildParentNumberingMap.get(child);
                    output.append(lineSeparator);
                    if (currentParentNumber < 10) {
                        output.append("   " + currentParentNumber);
                    } else if (currentParentNumber < 100) {
                        output.append("  " + currentParentNumber);
                    } else if (currentParentNumber < 1000) {
                        output.append(" " + currentParentNumber);
                    } else {
                        output.append(currentParentNumber);
                    }
                    output.append("  " + child.getCharacter().getName() + " = ");
                } else {
                    output.append("    ");
                    String blankCharacterName = "";
                    int i = 0;
                    while (i < child.getCharacter().getName().length()) {
                        blankCharacterName = String.valueOf(blankCharacterName) + " ";
                        ++i;
                    }
                    output.append("  " + blankCharacterName + " = ");
                }
                if (child.getCharacterState() instanceof QuantitativeMeasure) {
                    output.append(((QuantitativeMeasure)child.getCharacterState()).toStringInterval(((QuantitativeCharacter)child.getCharacter()).getMeasurementUnit()));
                } else {
                    output.append(child.getStringStates());
                }
                output.append(tree2dump.nodeDescriptionAnalysis(child));
                if (child.getChildren().size() == 0) {
                    output.append(" -> ");
                    boolean firstLoop = true;
                    for (Taxon taxon : child.getRemainingTaxa()) {
                        if (!firstLoop) {
                            output.append(", ");
                        }
                        output.append(taxon.getName());
                        firstLoop = false;
                    }
                } else {
                    output.append(" -> " + counter);
                }
                output.append(lineSeparator);
                queue.add(child);
                if (!child.hasChild()) continue;
                ++counter;
            }
        }
    }

    public static File dumpHtmlFile(String header, SingleAccessKeyTree tree2dump, boolean showStatistics) throws IOException {
        String path = String.valueOf(Utils.getBundleConfOverridableElement("generatedKeyFiles.prefix")) + Utils.getBundleConfOverridableElement("generatedKeyFiles.folder");
        File htmlFile = File.createTempFile("key_", ".html", new File(path));
        FileOutputStream fileOutputStream = new FileOutputStream(htmlFile);
        fileOutputStream.write(new byte[]{-17, -69, -65});
        BufferedWriter htmlFileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"));
        htmlFileWriter.append(SingleAccessKeyTreeDumper.generateHtmlString(header, tree2dump, showStatistics));
        htmlFileWriter.close();
        return htmlFile;
    }

    private static String generateHtmlString(String header, SingleAccessKeyTree tree2dump, boolean showStatistics) throws IOException {
        String lineSep = System.getProperty("line.separator");
        StringBuffer slk = new StringBuffer();
        slk.append("<html>" + lineSep);
        slk.append("<meta http-equiv='Content-Type' content='text/html; charset=UTF-8' />" + lineSep);
        slk.append("<head>" + lineSep);
        slk.append("<script src='" + Utils.getBundleConfElement("resources.jqueryPath") + "'></script>" + lineSep + "<script type='text/javascript' src='" + Utils.getBundleConfElement("resources.treeviewJsPath") + "'></script>" + lineSep + "<link rel='stylesheet' href='" + Utils.getBundleConfElement("resources.treeviewCssPath") + "' type='text/css' />" + lineSep);
        slk.append("<style type='text/css'>" + lineSep);
        InputStream cssInputStream = SingleAccessKeyTreeDumper.class.getResourceAsStream(Utils.getBundleConfElement("resources.CSSName"));
        if (cssInputStream != null) {
            BufferedInputStream bin = new BufferedInputStream(cssInputStream);
            byte[] contents = new byte[1024];
            int bytesRead = 0;
            while ((bytesRead = bin.read(contents)) != -1) {
                String strFileContents = new String(contents, 0, bytesRead);
                slk.append(strFileContents);
            }
        }
        slk.append("</style>" + lineSep);
        slk.append("<script>" + lineSep);
        InputStream javascriptInputStream = SingleAccessKeyTreeDumper.class.getResourceAsStream(Utils.getBundleConfElement("resources.JSName"));
        if (javascriptInputStream != null) {
            BufferedInputStream bin = new BufferedInputStream(javascriptInputStream);
            byte[] contents = new byte[1024];
            int bytesRead = 0;
            while ((bytesRead = bin.read(contents)) != -1) {
                String strFileContents = new String(contents, 0, bytesRead);
                slk.append(strFileContents);
            }
        }
        slk.append("</script>" + lineSep);
        slk.append("</head>" + lineSep);
        slk.append("<body onLoad='initTree();' >" + lineSep);
        slk.append("<div style='margin-left:30px;margin-top:20px;'>" + lineSep);
        slk.append(header.replaceAll(System.getProperty("line.separator"), "<br/>"));
        slk.append("<div id=\"treecontrol\"><a title=\"Collapse the entire tree below\" href=\"#\" onClick=\"window.location.href=window.location.href\">Collapse All</a> | <a title=\"Expand the entire tree below\" href=\"#\">Expand All</a></div>" + lineSep);
        slk.append("<ul id='tree'>" + lineSep);
        StringBuffer output = new StringBuffer();
        SingleAccessKeyTreeDumper.recursiveToHTMLString(tree2dump.getRoot(), null, output, "", true, 0, 0, tree2dump);
        slk.append(output.toString());
        slk.append("</ul>" + lineSep);
        slk.append("</div>" + lineSep);
        if (showStatistics) {
            tree2dump.gatherTaxonPathStatistics();
            slk.append(SingleAccessKeyTreeDumper.outputTaxonPathStatisticsHTML(tree2dump));
        }
        slk.append("</body>");
        slk.append("</html>");
        return slk.toString();
    }

    private static void recursiveToHTMLString(SingleAccessKeyNode node, SingleAccessKeyNode parentNode, StringBuffer output, String tabulations, boolean displayCharacterName, int firstNumbering, int secondNumbering, SingleAccessKeyTree tree2dump) {
        String characterName = null;
        String state = null;
        if (node != null && node.getCharacter() != null && node.getCharacterState() != null) {
            if (displayCharacterName) {
                characterName = node.getCharacter().getName().replaceAll("\\<", "&lt;").replaceAll("\\>", "&gt;");
                characterName = "<span class='character'>" + firstNumbering + ") " + "<b>" + characterName + "</b>" + "</span>";
                String htmlImageLink = "";
                if (parentNode.isChildrenContainsImages(tree2dump.getDataSet())) {
                    String javascriptStateNameTab = "new Array(";
                    String javascriptUrlImageTab = "new Array(";
                    boolean firstLoop = true;
                    for (SingleAccessKeyNode childNode : parentNode.getChildren()) {
                        if (!childNode.getCharacter().isSupportsCategoricalData()) continue;
                        if (!firstLoop) {
                            javascriptStateNameTab = String.valueOf(javascriptStateNameTab) + ", ";
                            javascriptUrlImageTab = String.valueOf(javascriptUrlImageTab) + ", ";
                        }
                        javascriptStateNameTab = String.valueOf(javascriptStateNameTab) + "\"" + ((State)childNode.getCharacterState()).getName().replaceAll("\"", "").replaceAll("'", " ") + "\"";
                        javascriptUrlImageTab = String.valueOf(javascriptUrlImageTab) + "\"" + ((State)childNode.getCharacterState()).getFirstImage(tree2dump.getDataSet()) + "\"";
                        firstLoop = false;
                    }
                    javascriptStateNameTab = String.valueOf(javascriptStateNameTab) + ")";
                    javascriptUrlImageTab = String.valueOf(javascriptUrlImageTab) + ")";
                    htmlImageLink = " <a class='stateImageLink' onClick='newStateImagesWindowTree(\"" + node.getCharacter().getName().replaceAll("\"", "").replaceAll("'", " ") + "\", " + javascriptStateNameTab + ", " + javascriptUrlImageTab + ");' >(<strong>?</strong>)</a>";
                }
                output.append(String.valueOf(tabulations) + "\t<li>" + characterName + htmlImageLink + "</li>");
            }
            state = node.getCharacterState() instanceof QuantitativeMeasure ? ((QuantitativeMeasure)node.getCharacterState()).toStringInterval(((QuantitativeCharacter)node.getCharacter()).getMeasurementUnit()) : node.getStringStates();
            state = "<span class='state'>" + firstNumbering + "." + secondNumbering + ") " + state.replaceAll("\\<", "&lt;").replaceAll("\\>", "&gt;") + "</span>";
            state = String.valueOf(state) + "<span class=\"warning\">" + tree2dump.nodeDescriptionAnalysis(node) + "</span>";
            output.append("\n" + tabulations + "\t<li>");
            if (node.hasChild()) {
                output.append("&nbsp;" + state + " (items=" + node.getRemainingTaxa().size() + ")");
            } else {
                output.append("&nbsp;" + state + "<span class='taxa'> -> ");
                boolean firstLoop = true;
                for (Taxon taxon : node.getRemainingTaxa()) {
                    if (!firstLoop) {
                        output.append(", ");
                    }
                    if (taxon.getFirstImage(tree2dump.getDataSet()) != null) {
                        output.append("<a href=\"" + taxon.getFirstImage(tree2dump.getDataSet()) + "\" class=\"screenshot\" rel=\"" + taxon.getFirstImage(tree2dump.getDataSet()) + "\" target=\"_blank\">" + taxon.getName() + "</a>");
                    } else {
                        output.append(taxon.getName());
                    }
                    firstLoop = false;
                }
                output.append("</span>");
            }
            if (node.hasChild()) {
                output.append("<ul>");
            }
            output.append(System.getProperty("line.separator"));
            tabulations = String.valueOf(tabulations) + "\t";
        }
        ++firstNumbering;
        secondNumbering = 0;
        boolean firstLoop = true;
        for (SingleAccessKeyNode childNode : node.getChildren()) {
            ++secondNumbering;
            if (firstLoop) {
                SingleAccessKeyTreeDumper.recursiveToHTMLString(childNode, node, output, tabulations, true, firstNumbering, secondNumbering, tree2dump);
            } else {
                SingleAccessKeyTreeDumper.recursiveToHTMLString(childNode, node, output, tabulations, false, firstNumbering, secondNumbering, tree2dump);
            }
            firstLoop = false;
        }
        if (node != null && node.getCharacter() != null && node.getCharacterState() != null) {
            if (node.hasChild()) {
                output.append(String.valueOf(tabulations) + "</li></ul>\n");
            } else {
                output.append(String.valueOf(tabulations) + "</li>\n");
            }
        }
    }

    public static File dumpFlatHtmlFile(String header, SingleAccessKeyTree tree2dump, boolean showStatistics) throws IOException {
        String path = String.valueOf(Utils.getBundleConfOverridableElement("generatedKeyFiles.prefix")) + Utils.getBundleConfOverridableElement("generatedKeyFiles.folder");
        File htmlFile = File.createTempFile("key_", ".html", new File(path));
        FileOutputStream fileOutputStream = new FileOutputStream(htmlFile);
        fileOutputStream.write(new byte[]{-17, -69, -65});
        BufferedWriter htmlFileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"));
        htmlFileWriter.append(SingleAccessKeyTreeDumper.generateFlatHtmlString(header, tree2dump, showStatistics));
        htmlFileWriter.close();
        return htmlFile;
    }

    public static File dumpInteractiveHtmlFile(String header, SingleAccessKeyTree tree2dump, boolean showStatistics) throws IOException {
        String path = String.valueOf(Utils.getBundleConfOverridableElement("generatedKeyFiles.prefix")) + Utils.getBundleConfOverridableElement("generatedKeyFiles.folder");
        File htmlFile = File.createTempFile("key_", ".html", new File(path));
        FileOutputStream fileOutputStream = new FileOutputStream(htmlFile);
        fileOutputStream.write(new byte[]{-17, -69, -65});
        BufferedWriter htmlFileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"));
        htmlFileWriter.append(SingleAccessKeyTreeDumper.generateInteractiveHtmlString(header, tree2dump, showStatistics));
        htmlFileWriter.close();
        return htmlFile;
    }

    private static String generateFlatHtmlString(String header, SingleAccessKeyTree tree2dump, boolean showStatistics) throws IOException {
        StringBuffer output = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        StringBuffer slk = new StringBuffer();
        slk.append("<html>" + lineSep);
        slk.append("<meta http-equiv='Content-Type' content='text/html; charset=UTF-8' />" + lineSep);
        slk.append("<head>" + lineSep);
        slk.append("<script src='" + Utils.getBundleConfElement("resources.jqueryPath") + "'></script>" + lineSep);
        slk.append("<style type='text/css'>" + lineSep);
        InputStream cssInputStream = SingleAccessKeyTreeDumper.class.getResourceAsStream(Utils.getBundleConfElement("resources.CSSName"));
        if (cssInputStream != null) {
            BufferedInputStream bin = new BufferedInputStream(cssInputStream);
            byte[] contents = new byte[1024];
            int bytesRead = 0;
            while ((bytesRead = bin.read(contents)) != -1) {
                String strFileContents = new String(contents, 0, bytesRead);
                slk.append(strFileContents);
            }
        }
        slk.append("</style>" + lineSep);
        slk.append("<script>" + lineSep);
        InputStream javascriptInputStream = SingleAccessKeyTreeDumper.class.getResourceAsStream(Utils.getBundleConfElement("resources.JSName"));
        if (javascriptInputStream != null) {
            BufferedInputStream bin = new BufferedInputStream(javascriptInputStream);
            byte[] contents = new byte[1024];
            int bytesRead = 0;
            while ((bytesRead = bin.read(contents)) != -1) {
                String strFileContents = new String(contents, 0, bytesRead);
                slk.append(strFileContents);
            }
        }
        slk.append("</script>" + lineSep);
        slk.append("</head>" + lineSep);
        slk.append("<body>" + lineSep);
        slk.append("<div style='margin-left:30px;margin-top:20px;'>" + lineSep);
        slk.append(header.replaceAll(System.getProperty("line.separator"), "<br/>"));
        SingleAccessKeyTreeDumper.multipleTraversalToHTMLString(tree2dump.getRoot(), output, System.getProperty("line.separator"), true, tree2dump);
        slk.append(output.toString());
        slk.append("</div>" + lineSep);
        if (showStatistics) {
            tree2dump.gatherTaxonPathStatistics();
            slk.append(SingleAccessKeyTreeDumper.outputTaxonPathStatisticsHTML(tree2dump));
        }
        slk.append("</body>");
        slk.append("</html>");
        return slk.toString();
    }

    private static String generateInteractiveHtmlString(String header, SingleAccessKeyTree tree2dump, boolean showStatistics) throws IOException {
        StringBuffer output = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        StringBuffer slk = new StringBuffer();
        slk.append("<html>" + lineSep);
        slk.append("<meta http-equiv='Content-Type' content='text/html; charset=UTF-8' />" + lineSep);
        slk.append("<script type=\"text/javascript\">" + lineSep);
        slk.append("if(screen.width<640 && screen.height < 500) {" + lineSep);
        slk.append("  document.write('<meta name = \"viewport\" content = \"width = 250\">') ;" + lineSep);
        slk.append("}" + lineSep);
        slk.append("</script>");
        slk.append("<head>" + lineSep);
        slk.append("<script src='" + Utils.getBundleConfElement("resources.jqueryPath") + "'></script>" + lineSep);
        slk.append("<style type='text/css'>" + lineSep);
        InputStream cssInputStream = SingleAccessKeyTreeDumper.class.getResourceAsStream(Utils.getBundleConfElement("resources.CSSName"));
        if (cssInputStream != null) {
            BufferedInputStream bin = new BufferedInputStream(cssInputStream);
            byte[] contents = new byte[1024];
            int bytesRead = 0;
            while ((bytesRead = bin.read(contents)) != -1) {
                String strFileContents = new String(contents, 0, bytesRead);
                slk.append(strFileContents);
            }
        }
        slk.append("</style>" + lineSep);
        slk.append("<script>" + lineSep);
        InputStream javascriptInputStream = SingleAccessKeyTreeDumper.class.getResourceAsStream(Utils.getBundleConfElement("resources.JSName"));
        if (javascriptInputStream != null) {
            BufferedInputStream bin = new BufferedInputStream(javascriptInputStream);
            byte[] contents = new byte[1024];
            int bytesRead = 0;
            while ((bytesRead = bin.read(contents)) != -1) {
                String strFileContents = new String(contents, 0, bytesRead);
                slk.append(strFileContents);
            }
        }
        slk.append("</script>" + lineSep);
        slk.append("</head>" + lineSep);
        slk.append("<body onLoad='initViewNodes();'>" + lineSep);
        slk.append("<div id=\"keyWait\" style='margin-left:30px;margin-top:20px;' >" + lineSep);
        slk.append("Generating Key, please wait...");
        slk.append("</div>" + lineSep);
        slk.append("<div id=\"keyBody\" style='visibility: hidden; margin-left:30px;margin-top:20px;'>" + lineSep);
        slk.append(header.replaceAll(System.getProperty("line.separator"), "<br/>"));
        slk.append("<input type='button' value='Previous Step' onClick='goToPreviousViewNode();' />");
        slk.append("<input type='button' value='RESET' onClick='goToFirstViewNode();' />");
        slk.append("<br/>");
        SingleAccessKeyTreeDumper.multipleTraversalToInteractiveHTMLString(tree2dump.getRoot(), output, System.getProperty("line.separator"), true, tree2dump);
        slk.append(output.toString());
        slk.append("</div>" + lineSep);
        if (showStatistics) {
            tree2dump.gatherTaxonPathStatistics();
            slk.append(SingleAccessKeyTreeDumper.outputTaxonPathStatisticsHTML(tree2dump));
        }
        slk.append("</body>");
        slk.append("</html>");
        return slk.toString();
    }

    private static void multipleTraversalToHTMLString(SingleAccessKeyNode rootNode, StringBuffer output, String lineSeparator, boolean activeLink, SingleAccessKeyTree tree2dump) {
        String marging = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
        HashMap<SingleAccessKeyNode, Integer> nodeBreadthFirstIterationMap = new HashMap<SingleAccessKeyNode, Integer>();
        int counter = 1;
        SingleAccessKeyTreeDumper.iterativeBreadthFirstSkipChildlessNodes(rootNode, nodeBreadthFirstIterationMap, counter);
        HashMap<SingleAccessKeyNode, Integer> nodeChildParentNumberingMap = new HashMap<SingleAccessKeyNode, Integer>();
        SingleAccessKeyTreeDumper.recursiveDepthFirstNodeIndex(rootNode, nodeBreadthFirstIterationMap, nodeChildParentNumberingMap);
        LinkedList<SingleAccessKeyNode> queue = new LinkedList<SingleAccessKeyNode>();
        ArrayList<SingleAccessKeyNode> visitedNodes = new ArrayList<SingleAccessKeyNode>();
        counter = 1;
        int currentParentNumber = -1;
        queue.add(rootNode);
        ++counter;
        visitedNodes.add(rootNode);
        while (!queue.isEmpty()) {
            SingleAccessKeyNode node = (SingleAccessKeyNode)queue.remove();
            SingleAccessKeyNode child = null;
            while (Utils.exclusion(node.getChildren(), visitedNodes).size() > 0 && (child = (SingleAccessKeyNode)Utils.exclusion(node.getChildren(), visitedNodes).get(0)) != null) {
                visitedNodes.add(child);
                if (nodeChildParentNumberingMap.get(child) != currentParentNumber) {
                    currentParentNumber = nodeChildParentNumberingMap.get(child);
                    output.append("<br/>" + lineSeparator);
                    if (currentParentNumber < 10) {
                        output.append("   ");
                    } else if (currentParentNumber < 100) {
                        output.append("  ");
                    } else if (currentParentNumber < 1000) {
                        output.append(" ");
                    }
                    if (currentParentNumber > 1) {
                        output.append(String.valueOf(lineSeparator) + "</span>");
                    }
                    output.append("<span class=\"viewNode\" id=\"viewNode" + currentParentNumber + "\">");
                    if (activeLink) {
                        output.append("<a name=\"anchor" + currentParentNumber + "\"></a>");
                    }
                    output.append("<strong>" + currentParentNumber + "</strong>");
                    String htmlImageLink = "";
                    if (node.isChildrenContainsImages(tree2dump.getDataSet())) {
                        htmlImageLink = "<a class='stateImageLink' onClick='newStateImagesWindow(" + currentParentNumber + ");' >(<strong>?</strong>)</a>";
                    }
                    output.append("  <span class=\"character\">" + child.getCharacter().getName().replace(">", "&gt;").replace("<", "&lt;") + " </span>" + htmlImageLink + ":<br/>");
                } else {
                    output.append("    ");
                    String blankCharacterName = "";
                    int i = 0;
                    while (i < child.getCharacter().getName().length()) {
                        blankCharacterName = String.valueOf(blankCharacterName) + " ";
                        ++i;
                    }
                    output.append("  " + blankCharacterName);
                }
                output.append("<span class=\"statesAndTaxa\">");
                String mediaKey = "";
                if (child.getCharacterState() instanceof QuantitativeMeasure) {
                    output.append("<span class=\"state\"\">" + marging + ((QuantitativeMeasure)child.getCharacterState()).toStringInterval(((QuantitativeCharacter)child.getCharacter()).getMeasurementUnit()) + "</span>");
                } else {
                    mediaKey = ((State)child.getCharacterState()).getFirstImageKey();
                    output.append("<span class=\"state\" id=\"state_" + mediaKey + "\" >" + marging + child.getStringStates().replace(">", "&gt;").replace("<", "&lt;") + "</span>");
                }
                output.append("<span class=\"warning\">" + tree2dump.nodeDescriptionAnalysis(child) + "</span>");
                if (child.getChildren().size() == 0) {
                    output.append(" =&gt; <span class=\"taxa\">");
                    boolean firstLoop = true;
                    for (Taxon taxon : child.getRemainingTaxa()) {
                        if (!firstLoop) {
                            output.append(", ");
                        }
                        if (taxon.getFirstImage(tree2dump.getDataSet()) != null) {
                            output.append("<a href=\"" + taxon.getFirstImage(tree2dump.getDataSet()) + "\" class=\"screenshot\" rel=\"" + taxon.getFirstImage(tree2dump.getDataSet()) + "\" target=\"_blank\">" + taxon.getName() + "</a>");
                        } else {
                            output.append(taxon.getName());
                        }
                        firstLoop = false;
                    }
                    output.append("</span>");
                } else if (activeLink) {
                    output.append(" =&gt; <a href=\"#anchor" + counter + "\">" + counter + "</a>");
                } else {
                    output.append(" =&gt; " + counter);
                }
                output.append("</span>");
                if (child.getCharacter().isSupportsCategoricalData()) {
                    output.append("<span class=\"stateImageURL\" id=\"stateImageURL_" + mediaKey + "\">");
                    output.append(((State)child.getCharacterState()).getFirstImage(tree2dump.getDataSet()) != null ? ((State)child.getCharacterState()).getFirstImage(tree2dump.getDataSet()) : "");
                    output.append("</span>");
                }
                output.append("<br/>" + lineSeparator);
                queue.add(child);
                if (!child.hasChild()) continue;
                ++counter;
            }
        }
    }

    private static void multipleTraversalToInteractiveHTMLString(SingleAccessKeyNode rootNode, StringBuffer output, String lineSeparator, boolean activeLink, SingleAccessKeyTree tree2dump) {
        String marging = "<br/>&nbsp;&nbsp;&nbsp;";
        HashMap<SingleAccessKeyNode, Integer> nodeBreadthFirstIterationMap = new HashMap<SingleAccessKeyNode, Integer>();
        int counter = 1;
        SingleAccessKeyTreeDumper.iterativeBreadthFirstSkipChildlessNodes(rootNode, nodeBreadthFirstIterationMap, counter);
        HashMap<SingleAccessKeyNode, Integer> nodeChildParentNumberingMap = new HashMap<SingleAccessKeyNode, Integer>();
        SingleAccessKeyTreeDumper.recursiveDepthFirstNodeIndex(rootNode, nodeBreadthFirstIterationMap, nodeChildParentNumberingMap);
        LinkedList<SingleAccessKeyNode> queue = new LinkedList<SingleAccessKeyNode>();
        ArrayList<SingleAccessKeyNode> visitedNodes = new ArrayList<SingleAccessKeyNode>();
        counter = 1;
        int currentParentNumber = -1;
        queue.add(rootNode);
        ++counter;
        visitedNodes.add(rootNode);
        while (!queue.isEmpty()) {
            SingleAccessKeyNode node = (SingleAccessKeyNode)queue.remove();
            SingleAccessKeyNode child = null;
            while (Utils.exclusion(node.getChildren(), visitedNodes).size() > 0 && (child = (SingleAccessKeyNode)Utils.exclusion(node.getChildren(), visitedNodes).get(0)) != null) {
                visitedNodes.add(child);
                if (nodeChildParentNumberingMap.get(child) != currentParentNumber) {
                    currentParentNumber = nodeChildParentNumberingMap.get(child);
                    output.append("<br/>" + lineSeparator);
                    if (currentParentNumber < 10) {
                        output.append("   ");
                    } else if (currentParentNumber < 100) {
                        output.append("  ");
                    } else if (currentParentNumber < 1000) {
                        output.append(" ");
                    }
                    if (currentParentNumber > 1) {
                        output.append(String.valueOf(lineSeparator) + "</span>");
                    }
                    output.append("<span class=\"viewNode\" id=\"viewNode" + currentParentNumber + "\">");
                    if (activeLink) {
                        output.append("<a name=\"anchor" + currentParentNumber + "\"></a>");
                    }
                    output.append("<strong>" + currentParentNumber + "</strong>");
                    String htmlImageLink = "";
                    output.append("  <span class=\"character\">" + child.getCharacter().getName().replace(">", "&gt;").replace("<", "&lt;") + " </span>" + htmlImageLink + ":<br/>");
                } else {
                    output.append("    ");
                    String blankCharacterName = "";
                    int i = 0;
                    while (i < child.getCharacter().getName().length()) {
                        blankCharacterName = String.valueOf(blankCharacterName) + " ";
                        ++i;
                    }
                    output.append("  " + blankCharacterName);
                }
                output.append("<span class=\"statesAndTaxa\">");
                String mediaKey = "";
                if (child.getCharacterState() instanceof QuantitativeMeasure) {
                    output.append("<span class=\"state\"\">" + marging + ((QuantitativeMeasure)child.getCharacterState()).toStringInterval(((QuantitativeCharacter)child.getCharacter()).getMeasurementUnit()) + "</span>");
                } else {
                    mediaKey = ((State)child.getCharacterState()).getFirstImageKey();
                    output.append("<span class=\"state\" id=\"state_" + mediaKey + "\" >" + marging + child.getStringStates().replace(">", "&gt;").replace("<", "&lt;") + "</span>");
                }
                output.append("<span class=\"warning\">" + tree2dump.nodeDescriptionAnalysis(child) + "</span>");
                if (child.getChildren().size() == 0) {
                    output.append(" => <span class=\"taxa\">");
                    boolean firstLoop = true;
                    for (Taxon taxon : child.getRemainingTaxa()) {
                        if (!firstLoop) {
                            output.append(", ");
                        }
                        if (taxon.getFirstImage(tree2dump.getDataSet()) != null) {
                            output.append("<a href=\"" + taxon.getFirstImage(tree2dump.getDataSet()) + "\" class=\"screenshot\" rel=\"" + taxon.getFirstImage(tree2dump.getDataSet()) + "\" target=\"_blank\">" + taxon.getName() + "</a>");
                        } else {
                            output.append(taxon.getName());
                        }
                        firstLoop = false;
                    }
                    output.append("</span>");
                } else if (activeLink) {
                    output.append(" => <input class=\"nextNodeButton\" type=\"button\" value=\"next step\" onClick='goToViewNode(" + counter + ")' />");
                } else {
                    output.append(" => " + counter);
                }
                output.append("</span>");
                if (child.getCharacter().isSupportsCategoricalData()) {
                    output.append("<br/><span class=\"stateImageURLandContainer\" id=\"stateImageURLandContainer" + counter + "\" >");
                    output.append("<span class=\"stateImageURL\" id=\"stateImageURL_" + mediaKey + "\">");
                    output.append(((State)child.getCharacterState()).getFirstImage(tree2dump.getDataSet()) != null ? ((State)child.getCharacterState()).getFirstImage(tree2dump.getDataSet()) : "");
                    output.append("</span>");
                    output.append("<br/><span class=\"stateImageContainer\" id=\"stateImageContainer" + counter + "\" ></span>" + lineSeparator);
                    output.append("</span>");
                }
                output.append("<br/>" + lineSeparator);
                queue.add(child);
                if (!child.hasChild()) continue;
                ++counter;
            }
        }
    }

    public static File dumpPdfFile(String header, SingleAccessKeyTree tree2dump, boolean showStatistics) throws IOException {
        try {
            String path = String.valueOf(Utils.getBundleConfOverridableElement("generatedKeyFiles.prefix")) + Utils.getBundleConfOverridableElement("generatedKeyFiles.folder");
            File pdfFile = File.createTempFile("key_", ".pdf", new File(path));
            Document pdfDocument = new Document(PageSize.A3, 50.0f, 50.0f, 50.0f, 50.0f);
            PdfWriter.getInstance((Document)pdfDocument, (OutputStream)new FileOutputStream(pdfFile));
            pdfDocument.open();
            StyleSheet styles = new StyleSheet();
            styles.loadTagStyle("body", "color", "#333");
            styles.loadTagStyle("body", "background", "#fff");
            styles.loadTagStyle("ul", "indent", "15");
            styles.loadTagStyle("li", "leading", "15");
            styles.loadTagStyle("li", "color", "#fff");
            styles.loadStyle("character", "color", "#333");
            styles.loadStyle("state", "color", "#fe8a22");
            styles.loadStyle("taxa", "color", "#67bb1b");
            styles.loadStyle("line", "color", "#333");
            styles.loadStyle("statisticsTable", "font-family", "Verdana, helvetica, arial, sans-serif;");
            styles.loadStyle("statisticsTable", "font-size", "78%");
            HTMLWorker htmlWorker = new HTMLWorker((DocListener)pdfDocument);
            htmlWorker.setStyleSheet(styles);
            StringBuffer output = new StringBuffer();
            output.append("<html><head></head><body>");
            output.append(header.replaceAll(System.getProperty("line.separator"), "<br/>"));
            output.append("<ul>");
            SingleAccessKeyTreeDumper.recursiveToHTMLStringForPdf(tree2dump.getRoot(), output, "", 0, 0, tree2dump);
            output.append("</ul>");
            if (showStatistics) {
                tree2dump.gatherTaxonPathStatistics();
                output.append(SingleAccessKeyTreeDumper.outputTaxonPathStatisticsHTML(tree2dump));
            }
            output.append("</body></html>");
            htmlWorker.parse((Reader)new StringReader(output.toString()));
            pdfDocument.close();
            htmlWorker.close();
            return pdfFile;
        }
        catch (IOException e) {
            tree2dump.getUtils().setErrorMessage(Utils.getBundleConfElement("message.creatingFileError"), e);
            e.printStackTrace();
        }
        catch (DocumentException e) {
            tree2dump.getUtils().setErrorMessage(Utils.getBundleConfElement("message.creatingFileError"), e);
            e.printStackTrace();
        }
        return null;
    }

    private static void recursiveToHTMLStringForPdf(SingleAccessKeyNode node, StringBuffer output, String tabulations, int firstNumbering, int secondNumbering, SingleAccessKeyTree tree2dump) {
        String characterName = null;
        String state = null;
        if (node != null && node.getCharacter() != null && node.getCharacterState() != null) {
            characterName = node.getCharacter().getName().replaceAll("\\<", "&lt;").replaceAll("\\>", "&gt;");
            characterName = String.valueOf(firstNumbering) + "." + secondNumbering + ") " + "<span class='character'>" + "<b>" + characterName + "</b>" + "</span>";
            output.append(String.valueOf(tabulations) + "\t<li>&nbsp;<span class='line'>" + characterName);
            state = node.getCharacterState() instanceof QuantitativeMeasure ? ((QuantitativeMeasure)node.getCharacterState()).toStringInterval(((QuantitativeCharacter)node.getCharacter()).getMeasurementUnit()) : node.getStringStates();
            state = "<span class='state'>" + state.replaceAll("\\<", "&lt;").replaceAll("\\>", "&gt;") + "</span>";
            state = String.valueOf(state) + "<span class=\"warning\">" + tree2dump.nodeDescriptionAnalysis(node) + "</span>";
            if (node.hasChild()) {
                output.append(" | " + state + " (items=" + node.getRemainingTaxa().size() + ")");
            } else {
                output.append(" | " + state + "<span class='taxa'> -> ");
                boolean firstLoop = true;
                for (Taxon taxon : node.getRemainingTaxa()) {
                    if (!firstLoop) {
                        output.append(", ");
                    }
                    output.append("<i>" + taxon.getName() + "</i>");
                    firstLoop = false;
                }
                output.append("</span>");
            }
            if (node.hasChild()) {
                output.append("</span><ul>");
            }
            output.append(System.getProperty("line.separator"));
            tabulations = String.valueOf(tabulations) + "\t";
        }
        ++firstNumbering;
        secondNumbering = 0;
        for (SingleAccessKeyNode childNode : node.getChildren()) {
            SingleAccessKeyTreeDumper.recursiveToHTMLStringForPdf(childNode, output, tabulations, firstNumbering, ++secondNumbering, tree2dump);
        }
        if (node != null && node.getCharacter() != null && node.getCharacterState() != null) {
            if (node.hasChild()) {
                output.append(String.valueOf(tabulations) + "</span></li></ul>\n");
            } else {
                output.append(String.valueOf(tabulations) + "</span></li>\n");
            }
        }
    }

    public static File dumpFlatPdfFile(String header, SingleAccessKeyTree tree2dump, boolean showStatistics) throws IOException {
        try {
            String path = String.valueOf(Utils.getBundleConfOverridableElement("generatedKeyFiles.prefix")) + Utils.getBundleConfOverridableElement("generatedKeyFiles.folder");
            File pdfFile = File.createTempFile("key_", ".pdf", new File(path));
            Document pdfDocument = new Document(PageSize.A3, 50.0f, 50.0f, 50.0f, 50.0f);
            PdfWriter.getInstance((Document)pdfDocument, (OutputStream)new FileOutputStream(pdfFile));
            pdfDocument.open();
            StyleSheet styles = new StyleSheet();
            styles.loadTagStyle("body", "color", "#333");
            styles.loadTagStyle("body", "background", "#fff");
            styles.loadStyle("character", "color", "#333");
            styles.loadStyle("state", "color", "#fe8a22");
            styles.loadStyle("taxa", "color", "#67bb1b");
            styles.loadStyle("line", "color", "#333");
            HTMLWorker htmlWorker = new HTMLWorker((DocListener)pdfDocument);
            htmlWorker.setStyleSheet(styles);
            StringBuffer output = new StringBuffer();
            output.append("<html><head></head><body>");
            output.append(header.replaceAll(System.getProperty("line.separator"), "<br/>"));
            SingleAccessKeyTreeDumper.multipleTraversalToHTMLStringForPdf(tree2dump.getRoot(), output, System.getProperty("line.separator"), false, tree2dump);
            if (showStatistics) {
                tree2dump.gatherTaxonPathStatistics();
                output.append(SingleAccessKeyTreeDumper.outputTaxonPathStatisticsHTML(tree2dump));
            }
            output.append("</body></html>");
            htmlWorker.parse((Reader)new StringReader(output.toString()));
            pdfDocument.close();
            htmlWorker.close();
            return pdfFile;
        }
        catch (IOException e) {
            tree2dump.getUtils().setErrorMessage(Utils.getBundleConfElement("message.creatingFileError"), e);
            e.printStackTrace();
        }
        catch (DocumentException e) {
            tree2dump.getUtils().setErrorMessage(Utils.getBundleConfElement("message.creatingFileError"), e);
            e.printStackTrace();
        }
        return null;
    }

    private static void multipleTraversalToHTMLStringForPdf(SingleAccessKeyNode rootNode, StringBuffer output, String lineSeparator, boolean activeLink, SingleAccessKeyTree tree2dump) {
        String marging = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
        HashMap<SingleAccessKeyNode, Integer> nodeBreadthFirstIterationMap = new HashMap<SingleAccessKeyNode, Integer>();
        int counter = 1;
        SingleAccessKeyTreeDumper.iterativeBreadthFirstSkipChildlessNodes(rootNode, nodeBreadthFirstIterationMap, counter);
        HashMap<SingleAccessKeyNode, Integer> nodeChildParentNumberingMap = new HashMap<SingleAccessKeyNode, Integer>();
        SingleAccessKeyTreeDumper.recursiveDepthFirstNodeIndex(rootNode, nodeBreadthFirstIterationMap, nodeChildParentNumberingMap);
        LinkedList<SingleAccessKeyNode> queue = new LinkedList<SingleAccessKeyNode>();
        ArrayList<SingleAccessKeyNode> visitedNodes = new ArrayList<SingleAccessKeyNode>();
        counter = 1;
        int currentParentNumber = -1;
        queue.add(rootNode);
        ++counter;
        visitedNodes.add(rootNode);
        while (!queue.isEmpty()) {
            SingleAccessKeyNode node = (SingleAccessKeyNode)queue.remove();
            SingleAccessKeyNode child = null;
            while (Utils.exclusion(node.getChildren(), visitedNodes).size() > 0 && (child = (SingleAccessKeyNode)Utils.exclusion(node.getChildren(), visitedNodes).get(0)) != null) {
                visitedNodes.add(child);
                if (nodeChildParentNumberingMap.get(child) != currentParentNumber) {
                    currentParentNumber = nodeChildParentNumberingMap.get(child);
                    output.append("<br/>" + lineSeparator);
                    if (currentParentNumber < 10) {
                        output.append("   ");
                    } else if (currentParentNumber < 100) {
                        output.append("  ");
                    } else if (currentParentNumber < 1000) {
                        output.append(" ");
                    }
                    if (currentParentNumber > 1) {
                        output.append(String.valueOf(lineSeparator) + "</span>");
                    }
                    output.append("<span class=\"viewNode\" id=\"viewNode" + currentParentNumber + "\">");
                    if (activeLink) {
                        output.append("<a name=\"anchor" + currentParentNumber + "\"></a>");
                    }
                    output.append("<strong>" + currentParentNumber + "</strong>");
                    output.append("  <span class=\"character\">" + child.getCharacter().getName().replace(">", "&gt;").replace("<", "&lt;") + " </span> :<br/>");
                } else {
                    output.append("    ");
                    String blankCharacterName = "";
                    int i = 0;
                    while (i < child.getCharacter().getName().length()) {
                        blankCharacterName = String.valueOf(blankCharacterName) + " ";
                        ++i;
                    }
                    output.append("  " + blankCharacterName);
                }
                output.append("<span class=\"statesAndTaxa\">");
                if (child.getCharacterState() instanceof QuantitativeMeasure) {
                    output.append("<span class=\"state\"\">" + marging + ((QuantitativeMeasure)child.getCharacterState()).toStringInterval(((QuantitativeCharacter)child.getCharacter()).getMeasurementUnit()) + "</span>");
                } else {
                    output.append("<span class=\"state\" id=\"state_\" >" + marging + child.getStringStates().replace(">", "&gt;").replace("<", "&lt;") + "</span>");
                }
                output.append("<span class=\"warning\">" + tree2dump.nodeDescriptionAnalysis(child) + "</span>");
                if (child.getChildren().size() == 0) {
                    output.append(" => <span class=\"taxa\">");
                    boolean firstLoop = true;
                    for (Taxon taxon : child.getRemainingTaxa()) {
                        if (!firstLoop) {
                            output.append(", ");
                        }
                        output.append(taxon.getName());
                        firstLoop = false;
                    }
                    output.append("</span>");
                } else if (activeLink) {
                    output.append(" => <a href=\"#anchor" + counter + "\">" + counter + "</a>");
                } else {
                    output.append(" => " + counter);
                }
                output.append("</span>");
                output.append("<br/>" + lineSeparator);
                queue.add(child);
                if (!child.hasChild()) continue;
                ++counter;
            }
        }
    }

    public static File dumpWikiFile(String header, SingleAccessKeyTree tree2dump, boolean showStatistics) throws IOException {
        String path = String.valueOf(Utils.getBundleConfOverridableElement("generatedKeyFiles.prefix")) + Utils.getBundleConfOverridableElement("generatedKeyFiles.folder");
        File wikiFile = File.createTempFile("key_", ".wiki", new File(path));
        FileOutputStream fileOutputStream = new FileOutputStream(wikiFile);
        fileOutputStream.write(new byte[]{-17, -69, -65});
        BufferedWriter wikiFileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"));
        if (header != null && !header.equals("")) {
            wikiFileWriter.append("== Info ==");
            wikiFileWriter.newLine();
            wikiFileWriter.append(header.replaceAll(System.getProperty("line.separator"), "<br>"));
            wikiFileWriter.newLine();
        }
        wikiFileWriter.append("== Identification Key==");
        wikiFileWriter.newLine();
        wikiFileWriter.append(SingleAccessKeyTreeDumper.generateTreeWiki(tree2dump, showStatistics));
        wikiFileWriter.close();
        return wikiFile;
    }

    private static String generateTreeWiki(SingleAccessKeyTree tree2dump, boolean showStatistics) {
        StringBuffer output = new StringBuffer();
        SingleAccessKeyTreeDumper.recursiveToWiki(tree2dump.getRoot(), output, "", 0, 0, tree2dump);
        if (showStatistics) {
            tree2dump.gatherTaxonPathStatistics();
            output.append(SingleAccessKeyTreeDumper.outputTaxonPathStatisticsWiki(tree2dump));
        }
        return output.toString();
    }

    private static void recursiveToWiki(SingleAccessKeyNode node, StringBuffer output, String tabulations, int firstNumbering, int secondNumbering, SingleAccessKeyTree tree2dump) {
        if (node != null && node.getCharacter() != null && node.getCharacterState() != null) {
            if (node.getCharacterState() instanceof QuantitativeMeasure) {
                output.append(String.valueOf(tabulations) + firstNumbering + "." + secondNumbering + ") " + "<span style=\"color:#333\">" + node.getCharacter().getName() + "</span> | " + "<span style=\"color:#fe8a22\">" + ((QuantitativeMeasure)node.getCharacterState()).toStringInterval(((QuantitativeCharacter)node.getCharacter()).getMeasurementUnit()) + "</span>");
            } else {
                output.append(String.valueOf(tabulations) + firstNumbering + "." + secondNumbering + ") " + "<span style=\"color:#333\">" + node.getCharacter().getName() + "</span> | " + "<span style=\"color:#fe8a22\">" + node.getStringStates() + "</span>");
            }
            output.append(tree2dump.nodeDescriptionAnalysis(node));
            if (node.getChildren().size() == 0) {
                output.append(" -> ");
                boolean firstLoop = true;
                for (Taxon taxon : node.getRemainingTaxa()) {
                    if (!firstLoop) {
                        output.append(", ");
                    }
                    output.append("<span style=\"color:#67bb1b\">" + taxon.getName() + "</span>");
                    firstLoop = false;
                }
            } else {
                output.append(" (items=" + node.getRemainingTaxa().size() + ")");
            }
            output.append(System.getProperty("line.separator"));
            tabulations = String.valueOf(tabulations) + ":";
        }
        ++firstNumbering;
        secondNumbering = 0;
        for (SingleAccessKeyNode childNode : node.getChildren()) {
            SingleAccessKeyTreeDumper.recursiveToWiki(childNode, output, tabulations, firstNumbering, ++secondNumbering, tree2dump);
        }
    }

    public static File dumpFlatWikiFile(String header, SingleAccessKeyTree tree2dump, boolean showStatistics) throws IOException {
        String path = String.valueOf(Utils.getBundleConfOverridableElement("generatedKeyFiles.prefix")) + Utils.getBundleConfOverridableElement("generatedKeyFiles.folder");
        File wikiFile = File.createTempFile("key_", ".wiki", new File(path));
        BufferedWriter wikiFlatFileWriter = new BufferedWriter(new FileWriter(wikiFile));
        if (header != null && !header.equals("")) {
            wikiFlatFileWriter.append("== Info ==");
            wikiFlatFileWriter.newLine();
            wikiFlatFileWriter.append(header.replaceAll(System.getProperty("line.separator"), "<br>"));
            wikiFlatFileWriter.newLine();
        }
        wikiFlatFileWriter.append("== Identification Key==");
        wikiFlatFileWriter.newLine();
        wikiFlatFileWriter.append(SingleAccessKeyTreeDumper.generateFlatWikiString(tree2dump));
        if (showStatistics) {
            tree2dump.gatherTaxonPathStatistics();
            wikiFlatFileWriter.append(SingleAccessKeyTreeDumper.outputTaxonPathStatisticsWiki(tree2dump));
        }
        wikiFlatFileWriter.close();
        return wikiFile;
    }

    private static String generateFlatWikiString(SingleAccessKeyTree tree2dump) {
        StringBuffer output = new StringBuffer();
        SingleAccessKeyTreeDumper.multipleTraversalToWikiString(tree2dump.getRoot(), output, System.getProperty("line.separator"), tree2dump);
        return output.toString();
    }

    private static void multipleTraversalToWikiString(SingleAccessKeyNode rootNode, StringBuffer output, String lineSeparator, SingleAccessKeyTree tree2dump) {
        HashMap<SingleAccessKeyNode, Integer> nodeBreadthFirstIterationMap = new HashMap<SingleAccessKeyNode, Integer>();
        int counter = 1;
        SingleAccessKeyTreeDumper.iterativeBreadthFirstSkipChildlessNodes(rootNode, nodeBreadthFirstIterationMap, counter);
        HashMap<SingleAccessKeyNode, Integer> nodeChildParentNumberingMap = new HashMap<SingleAccessKeyNode, Integer>();
        SingleAccessKeyTreeDumper.recursiveDepthFirstNodeIndex(rootNode, nodeBreadthFirstIterationMap, nodeChildParentNumberingMap);
        LinkedList<SingleAccessKeyNode> queue = new LinkedList<SingleAccessKeyNode>();
        ArrayList<SingleAccessKeyNode> visitedNodes = new ArrayList<SingleAccessKeyNode>();
        counter = 1;
        int currentParentNumber = -1;
        queue.add(rootNode);
        ++counter;
        visitedNodes.add(rootNode);
        while (!queue.isEmpty()) {
            SingleAccessKeyNode node = (SingleAccessKeyNode)queue.remove();
            SingleAccessKeyNode child = null;
            while (Utils.exclusion(node.getChildren(), visitedNodes).size() > 0 && (child = (SingleAccessKeyNode)Utils.exclusion(node.getChildren(), visitedNodes).get(0)) != null) {
                visitedNodes.add(child);
                if (nodeChildParentNumberingMap.get(child) != currentParentNumber) {
                    currentParentNumber = nodeChildParentNumberingMap.get(child);
                    output.append(lineSeparator);
                    output.append("<span id=\"anchor" + currentParentNumber + "\"></span>" + currentParentNumber);
                    output.append("  " + child.getCharacter().getName());
                    output.append(lineSeparator);
                    output.append("::::::= ");
                } else {
                    output.append("::::::= ");
                }
                output.append("<span style=\"color:#fe8a22;\">");
                if (child.getCharacterState() instanceof QuantitativeMeasure) {
                    output.append(((QuantitativeMeasure)child.getCharacterState()).toStringInterval(((QuantitativeCharacter)child.getCharacter()).getMeasurementUnit()));
                } else {
                    output.append(child.getStringStates());
                }
                output.append("</span>");
                output.append("<span style=\"color: black;\">" + tree2dump.nodeDescriptionAnalysis(child) + "</span>");
                output.append(" &#8658; ");
                if (child.getChildren().size() == 0) {
                    boolean firstLoop = true;
                    for (Taxon taxon : child.getRemainingTaxa()) {
                        if (!firstLoop) {
                            output.append(", ");
                        }
                        output.append("<span style=\"color:#67bb1b;\">");
                        output.append("''" + taxon.getName() + "''");
                        output.append("</span>");
                        firstLoop = false;
                    }
                } else {
                    output.append("[[#anchor" + counter + "|<span style=\"color:#67bb1b;\"><u>" + counter + "</u></span>]]");
                }
                output.append(lineSeparator);
                queue.add(child);
                if (!child.hasChild()) continue;
                ++counter;
            }
        }
    }

    public static File dumpFlatSpeciesIDQuestionAnswerWikiFile(String header, SingleAccessKeyTree tree2dump) throws IOException {
        String path = String.valueOf(Utils.getBundleConfOverridableElement("generatedKeyFiles.prefix")) + Utils.getBundleConfOverridableElement("generatedKeyFiles.folder");
        File wikiFile = File.createTempFile("key_", ".wiki", new File(path));
        FileOutputStream fileOutputStream = new FileOutputStream(wikiFile);
        fileOutputStream.write(new byte[]{-17, -69, -65});
        BufferedWriter wikiFlatFileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"));
        if (header != null && !header.equals("")) {
            wikiFlatFileWriter.append("== Info ==");
            wikiFlatFileWriter.newLine();
            wikiFlatFileWriter.append(header.replaceAll(System.getProperty("line.separator"), "<br>"));
            wikiFlatFileWriter.newLine();
        }
        wikiFlatFileWriter.append("== Identification Key==");
        wikiFlatFileWriter.newLine();
        wikiFlatFileWriter.append(SingleAccessKeyTreeDumper.generateFlatSpeciesIDQuestionAnswerWikiString(tree2dump));
        wikiFlatFileWriter.close();
        return wikiFile;
    }

    private static String generateFlatSpeciesIDQuestionAnswerWikiString(SingleAccessKeyTree tree2dump) {
        StringBuffer output = new StringBuffer();
        SingleAccessKeyTreeDumper.multipleTraversalToSpeciesIDQuestionAnswerWikiString(tree2dump.getRoot(), output, System.getProperty("line.separator"), tree2dump);
        return output.toString();
    }

    private static void multipleTraversalToSpeciesIDQuestionAnswerWikiString(SingleAccessKeyNode rootNode, StringBuffer output, String lineSeparator, SingleAccessKeyTree tree2dump) {
        HashMap<SingleAccessKeyNode, Integer> nodeBreadthFirstIterationMap = new HashMap<SingleAccessKeyNode, Integer>();
        int counter = 1;
        SingleAccessKeyTreeDumper.iterativeBreadthFirstSkipChildlessNodes(rootNode, nodeBreadthFirstIterationMap, counter);
        HashMap<SingleAccessKeyNode, Integer> nodeChildParentNumberingMap = new HashMap<SingleAccessKeyNode, Integer>();
        SingleAccessKeyTreeDumper.recursiveDepthFirstNodeIndex(rootNode, nodeBreadthFirstIterationMap, nodeChildParentNumberingMap);
        LinkedList<SingleAccessKeyNode> queue = new LinkedList<SingleAccessKeyNode>();
        ArrayList<SingleAccessKeyNode> visitedNodes = new ArrayList<SingleAccessKeyNode>();
        counter = 1;
        int currentParentNumber = -1;
        queue.add(rootNode);
        ++counter;
        visitedNodes.add(rootNode);
        String[] alphabet = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
        int alphabetIndex = 0;
        output.append("{{Key Start|title=" + tree2dump.getLabel() + "}}" + lineSeparator);
        while (!queue.isEmpty()) {
            SingleAccessKeyNode node = (SingleAccessKeyNode)queue.remove();
            SingleAccessKeyNode child = null;
            while (Utils.exclusion(node.getChildren(), visitedNodes).size() > 0 && (child = (SingleAccessKeyNode)Utils.exclusion(node.getChildren(), visitedNodes).get(0)) != null) {
                visitedNodes.add(child);
                if (nodeChildParentNumberingMap.get(child) != currentParentNumber) {
                    currentParentNumber = nodeChildParentNumberingMap.get(child);
                    output.append(lineSeparator);
                    output.append("{{Lead Question |" + currentParentNumber + " | " + child.getCharacter().getName().replace(">", "&gt;").replace("<", "&lt;").replace(">", "&gt;").replace("=", "&#61;") + " }}");
                    output.append(lineSeparator);
                    alphabetIndex = 0;
                }
                String stateID = "";
                try {
                    if (alphabetIndex + 1 > alphabet.length) {
                        int quotient = (alphabetIndex + 1) / alphabet.length;
                        int modulo = (alphabetIndex + 1) % alphabet.length;
                        stateID = String.valueOf(alphabet[quotient - 1]) + alphabet[modulo - 1];
                    } else {
                        stateID = alphabet[alphabetIndex];
                    }
                }
                catch (Exception e) {
                    tree2dump.getUtils().setErrorMessage(Utils.getBundleConfElement("message.stateNumberError"), e);
                    e.printStackTrace();
                }
                output.append("{{Lead|" + currentParentNumber + " " + stateID + "|");
                ++alphabetIndex;
                if (child.getCharacterState() instanceof QuantitativeMeasure) {
                    output.append(((QuantitativeMeasure)child.getCharacterState()).toStringInterval(((QuantitativeCharacter)child.getCharacter()).getMeasurementUnit()));
                } else {
                    output.append(((State)child.getCharacterState()).getName().replace(">", "&gt;").replace("=", "&#61;").replace("<", "&lt;"));
                }
                output.append(tree2dump.nodeDescriptionAnalysis(child));
                output.append("|");
                if (child.getChildren().size() == 0) {
                    if (child.getRemainingTaxa().size() == 1) {
                        output.append("result=");
                    } else {
                        output.append("result text=");
                    }
                    boolean firstLoop = true;
                    for (Taxon taxon : child.getRemainingTaxa()) {
                        if (!firstLoop) {
                            output.append(", ");
                        }
                        output.append(taxon.getName().replace(">", "&gt;").replace("<", "&lt;").replace("=", "&#61;"));
                        firstLoop = false;
                    }
                } else {
                    output.append(counter);
                }
                output.append("}}");
                output.append(lineSeparator);
                queue.add(child);
                if (!child.hasChild()) continue;
                ++counter;
            }
        }
        output.append("{{Key End}}");
    }

    public static File dumpFlatSpeciesIDStatementWikiFile(String header, SingleAccessKeyTree tree2dump) throws IOException {
        String path = String.valueOf(Utils.getBundleConfOverridableElement("generatedKeyFiles.prefix")) + Utils.getBundleConfOverridableElement("generatedKeyFiles.folder");
        File wikiFile = File.createTempFile("key_", ".wiki", new File(path));
        FileOutputStream fileOutputStream = new FileOutputStream(wikiFile);
        fileOutputStream.write(new byte[]{-17, -69, -65});
        BufferedWriter wikiFlatFileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"));
        if (header != null && !header.equals("")) {
            wikiFlatFileWriter.append("== Info ==");
            wikiFlatFileWriter.newLine();
            wikiFlatFileWriter.append(header.replaceAll(System.getProperty("line.separator"), "<br>"));
            wikiFlatFileWriter.newLine();
        }
        wikiFlatFileWriter.append("== Identification Key==");
        wikiFlatFileWriter.newLine();
        wikiFlatFileWriter.append(SingleAccessKeyTreeDumper.generateFlatSpeciesIDStatementWikiString(tree2dump));
        wikiFlatFileWriter.close();
        return wikiFile;
    }

    private static String generateFlatSpeciesIDStatementWikiString(SingleAccessKeyTree tree2dump) {
        StringBuffer output = new StringBuffer();
        SingleAccessKeyTreeDumper.multipleTraversalToSpeciesIDStatementWikiString(tree2dump.getRoot(), output, System.getProperty("line.separator"), tree2dump);
        return output.toString();
    }

    private static void multipleTraversalToSpeciesIDStatementWikiString(SingleAccessKeyNode rootNode, StringBuffer output, String lineSeparator, SingleAccessKeyTree tree2dump) {
        LinkedList<SingleAccessKeyNode> queue = new LinkedList<SingleAccessKeyNode>();
        ArrayList<SingleAccessKeyNode> visitedNodes = new ArrayList<SingleAccessKeyNode>();
        HashMap<SingleAccessKeyNode, Integer> nodeBreadthFirstIterationMap = new HashMap<SingleAccessKeyNode, Integer>();
        int counter = 1;
        SingleAccessKeyTreeDumper.iterativeBreadthFirstSkipChildlessNodes(rootNode, nodeBreadthFirstIterationMap, counter);
        HashMap<SingleAccessKeyNode, Integer> nodeChildParentNumberingMap = new HashMap<SingleAccessKeyNode, Integer>();
        SingleAccessKeyTreeDumper.recursiveDepthFirstNodeIndex(rootNode, nodeBreadthFirstIterationMap, nodeChildParentNumberingMap);
        queue.clear();
        visitedNodes.clear();
        counter = 1;
        int currentParentNumber = -1;
        queue.add(rootNode);
        ++counter;
        visitedNodes.add(rootNode);
        output.append("{{Key Start|title=" + tree2dump.getLabel() + "}}" + lineSeparator);
        while (!queue.isEmpty()) {
            SingleAccessKeyNode node = (SingleAccessKeyNode)queue.remove();
            SingleAccessKeyNode child = null;
            while (Utils.exclusion(node.getChildren(), visitedNodes).size() > 0 && (child = (SingleAccessKeyNode)Utils.exclusion(node.getChildren(), visitedNodes).get(0)) != null) {
                visitedNodes.add(child);
                if (nodeChildParentNumberingMap.get(child) != currentParentNumber) {
                    currentParentNumber = nodeChildParentNumberingMap.get(child);
                    output.append("{{Lead|" + currentParentNumber + "|");
                } else {
                    output.append("{{Lead|" + currentParentNumber + "-|");
                }
                output.append(String.valueOf(child.getCharacter().getName()) + ":  ");
                if (child.getCharacterState() instanceof QuantitativeMeasure) {
                    output.append(((QuantitativeMeasure)child.getCharacterState()).toStringInterval(((QuantitativeCharacter)child.getCharacter()).getMeasurementUnit()));
                } else {
                    output.append(((State)child.getCharacterState()).getName().replace(">", "&gt;").replace("<", "&lt;").replace("=", "&#61;"));
                }
                output.append(tree2dump.nodeDescriptionAnalysis(child));
                output.append("|");
                if (child.getChildren().size() == 0) {
                    if (child.getRemainingTaxa().size() == 1) {
                        output.append("result=");
                    } else {
                        output.append("result text=");
                    }
                    boolean firstLoop = true;
                    for (Taxon taxon : child.getRemainingTaxa()) {
                        if (!firstLoop) {
                            output.append(", ");
                        }
                        output.append(taxon.getName().replace(">", "&gt;").replace("<", "&lt;").replace("=", "&#61;"));
                        firstLoop = false;
                    }
                } else {
                    output.append(counter);
                }
                output.append("}}");
                output.append(lineSeparator);
                queue.add(child);
                if (child.getChildren().size() <= 0) continue;
                ++counter;
            }
        }
        output.append("{{Key End}}");
    }

    public static File dumpDotFile(String header, SingleAccessKeyTree tree2dump) throws IOException {
        String path = String.valueOf(Utils.getBundleConfOverridableElement("generatedKeyFiles.prefix")) + Utils.getBundleConfOverridableElement("generatedKeyFiles.folder");
        header = header.replace(System.getProperty("line.separator"), String.valueOf(System.getProperty("line.separator")) + "//");
        header = String.valueOf(header) + System.getProperty("line.separator");
        File dotFile = File.createTempFile("key_", ".gv", new File(path));
        FileOutputStream fileOutputStream = new FileOutputStream(dotFile);
        fileOutputStream.write(new byte[]{-17, -69, -65});
        BufferedWriter dotFileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"));
        dotFileWriter.append(header);
        dotFileWriter.append("digraph " + dotFile.getName().split("\\.")[0] + " {");
        dotFileWriter.append(SingleAccessKeyTreeDumper.generateDotString(tree2dump));
        dotFileWriter.append(String.valueOf(System.getProperty("line.separator")) + "}");
        dotFileWriter.close();
        return dotFile;
    }

    private static String generateDotString(SingleAccessKeyTree tree2dump) {
        StringBuffer output = new StringBuffer();
        SingleAccessKeyTreeDumper.multipleTraversalToDotString(tree2dump.getRoot(), output, System.getProperty("line.separator"), tree2dump);
        return output.toString();
    }

    private static void multipleTraversalToDotString(SingleAccessKeyNode rootNode, StringBuffer output, String lineSeparator, SingleAccessKeyTree tree2dump) {
        HashMap<SingleAccessKeyNode, Integer> nodeBreadthFirstIterationMap = new HashMap<SingleAccessKeyNode, Integer>();
        int counter = 1;
        SingleAccessKeyTreeDumper.iterativeBreadthFirst(rootNode, nodeBreadthFirstIterationMap, counter);
        HashMap<Integer, Integer> nodeChildParentNumberingMap = new HashMap<Integer, Integer>();
        SingleAccessKeyTreeDumper.recursiveDepthFirstIntegerIndex(rootNode, nodeBreadthFirstIterationMap, nodeChildParentNumberingMap);
        LinkedList<SingleAccessKeyNode> queue = new LinkedList<SingleAccessKeyNode>();
        ArrayList<SingleAccessKeyNode> visitedNodes = new ArrayList<SingleAccessKeyNode>();
        counter = 1;
        int currentParentNumber = -1;
        queue.add(rootNode);
        ++counter;
        visitedNodes.add(rootNode);
        while (!queue.isEmpty()) {
            SingleAccessKeyNode node = (SingleAccessKeyNode)queue.remove();
            SingleAccessKeyNode child = null;
            while (Utils.exclusion(node.getChildren(), visitedNodes).size() > 0 && (child = (SingleAccessKeyNode)Utils.exclusion(node.getChildren(), visitedNodes).get(0)) != null) {
                visitedNodes.add(child);
                if (nodeChildParentNumberingMap.get(new Integer(counter)) != currentParentNumber) {
                    currentParentNumber = nodeChildParentNumberingMap.get(new Integer(counter));
                }
                output.append(lineSeparator);
                output.append(String.valueOf(currentParentNumber) + " -> ");
                output.append(counter);
                if (child.getCharacterState() instanceof QuantitativeMeasure) {
                    output.append(" [label=\"" + ((QuantitativeMeasure)child.getCharacterState()).toStringInterval(((QuantitativeCharacter)child.getCharacter()).getMeasurementUnit()));
                } else {
                    output.append(" [label=\"" + child.getStringStates());
                }
                output.append(tree2dump.nodeDescriptionAnalysis(child));
                output.append("\"]");
                output.append(";" + lineSeparator);
                if (child.getChildren().size() == 0) {
                    output.append(String.valueOf(currentParentNumber) + " [label=\"" + child.getCharacter().getName() + "\"];");
                    output.append(lineSeparator);
                    output.append(String.valueOf(counter) + " [label=\"");
                    boolean firstLoop = true;
                    for (Taxon taxon : child.getRemainingTaxa()) {
                        if (!firstLoop) {
                            output.append(", ");
                        }
                        output.append(taxon.getName());
                        firstLoop = false;
                    }
                    output.append("\",shape=box]");
                    output.append(";");
                } else {
                    output.append(String.valueOf(currentParentNumber) + " [label=\"");
                    output.append(String.valueOf(child.getCharacter().getName()) + "\"];");
                }
                output.append(lineSeparator);
                queue.add(child);
                ++counter;
            }
        }
    }

    public static File dumpZipFile(String header, SingleAccessKeyTree tree2dump, boolean showStatistics) throws IOException {
        File sddFile = SingleAccessKeyTreeDumper.dumpSddFile(header, tree2dump);
        File txtFile = SingleAccessKeyTreeDumper.dumpTxtFile(header, tree2dump, showStatistics);
        File flatTxtFile = SingleAccessKeyTreeDumper.dumpFlatTxtFile(header, tree2dump, showStatistics);
        File htmlFile = SingleAccessKeyTreeDumper.dumpHtmlFile(header, tree2dump, showStatistics);
        File flatHtmlFile = SingleAccessKeyTreeDumper.dumpFlatHtmlFile(header, tree2dump, showStatistics);
        File interactiveHtmlFile = SingleAccessKeyTreeDumper.dumpInteractiveHtmlFile(header, tree2dump, showStatistics);
        File pdfFile = SingleAccessKeyTreeDumper.dumpPdfFile(header, tree2dump, showStatistics);
        File flatPdfFile = SingleAccessKeyTreeDumper.dumpFlatPdfFile(header, tree2dump, showStatistics);
        File wikiFile = SingleAccessKeyTreeDumper.dumpWikiFile(header, tree2dump, showStatistics);
        File flatWikiFile = SingleAccessKeyTreeDumper.dumpFlatWikiFile(header, tree2dump, showStatistics);
        File flatSpeciesIDQuestionAnswerWikiFile = SingleAccessKeyTreeDumper.dumpFlatSpeciesIDQuestionAnswerWikiFile(header, tree2dump);
        File flatSpeciesIDStatementWikiFile = SingleAccessKeyTreeDumper.dumpFlatSpeciesIDStatementWikiFile(header, tree2dump);
        File dotFile = SingleAccessKeyTreeDumper.dumpDotFile(header, tree2dump);
        ArrayList<File> filesList = new ArrayList<File>();
        filesList.add(sddFile);
        filesList.add(txtFile);
        filesList.add(flatTxtFile);
        filesList.add(htmlFile);
        filesList.add(flatHtmlFile);
        filesList.add(interactiveHtmlFile);
        filesList.add(pdfFile);
        filesList.add(flatPdfFile);
        filesList.add(wikiFile);
        filesList.add(flatWikiFile);
        filesList.add(flatSpeciesIDQuestionAnswerWikiFile);
        filesList.add(flatSpeciesIDStatementWikiFile);
        filesList.add(dotFile);
        String label = "";
        if (tree2dump.getLabel() != null) {
            label = String.valueOf(tree2dump.getLabel()) + "-";
        }
        HashMap<File, String> correspondingFilePath = new HashMap<File, String>();
        correspondingFilePath.put(sddFile, String.valueOf(label) + "key" + System.getProperty("file.separator") + "flat" + System.getProperty("file.separator") + sddFile.getName());
        correspondingFilePath.put(txtFile, String.valueOf(label) + "key" + System.getProperty("file.separator") + "tree" + System.getProperty("file.separator") + txtFile.getName());
        correspondingFilePath.put(flatTxtFile, String.valueOf(label) + "key" + System.getProperty("file.separator") + "flat" + System.getProperty("file.separator") + flatTxtFile.getName());
        correspondingFilePath.put(htmlFile, String.valueOf(label) + "key" + System.getProperty("file.separator") + "tree" + System.getProperty("file.separator") + htmlFile.getName());
        correspondingFilePath.put(flatHtmlFile, String.valueOf(label) + "key" + System.getProperty("file.separator") + "flat" + System.getProperty("file.separator") + flatHtmlFile.getName());
        correspondingFilePath.put(interactiveHtmlFile, String.valueOf(label) + "key" + System.getProperty("file.separator") + "flat" + System.getProperty("file.separator") + interactiveHtmlFile.getName());
        correspondingFilePath.put(pdfFile, String.valueOf(label) + "key" + System.getProperty("file.separator") + "tree" + System.getProperty("file.separator") + pdfFile.getName());
        correspondingFilePath.put(flatPdfFile, String.valueOf(label) + "key" + System.getProperty("file.separator") + "flat" + System.getProperty("file.separator") + flatPdfFile.getName());
        correspondingFilePath.put(wikiFile, String.valueOf(label) + "key" + System.getProperty("file.separator") + "tree" + System.getProperty("file.separator") + wikiFile.getName());
        correspondingFilePath.put(flatWikiFile, String.valueOf(label) + "key" + System.getProperty("file.separator") + "flat" + System.getProperty("file.separator") + flatWikiFile.getName());
        correspondingFilePath.put(flatSpeciesIDQuestionAnswerWikiFile, String.valueOf(label) + "key" + System.getProperty("file.separator") + "flat" + System.getProperty("file.separator") + flatSpeciesIDQuestionAnswerWikiFile.getName());
        correspondingFilePath.put(flatSpeciesIDStatementWikiFile, String.valueOf(label) + "key" + System.getProperty("file.separator") + "flat" + System.getProperty("file.separator") + flatSpeciesIDStatementWikiFile.getName());
        correspondingFilePath.put(dotFile, String.valueOf(label) + "key" + System.getProperty("file.separator") + "tree" + System.getProperty("file.separator") + dotFile.getName());
        String path = String.valueOf(Utils.getBundleConfOverridableElement("generatedKeyFiles.prefix")) + Utils.getBundleConfOverridableElement("generatedKeyFiles.folder");
        File zipFile = File.createTempFile("key_", ".zip", new File(path));
        try {
            FileOutputStream dest = new FileOutputStream(zipFile);
            CheckedOutputStream checksum = new CheckedOutputStream(dest, new Adler32());
            BufferedOutputStream buff = new BufferedOutputStream(checksum);
            ZipOutputStream out = new ZipOutputStream(buff);
            out.setMethod(8);
            out.setLevel(9);
            byte[] data = new byte[Utils.BUFFER];
            for (File file : filesList) {
                int count;
                FileInputStream fi = new FileInputStream(file);
                BufferedInputStream buffi = new BufferedInputStream(fi, Utils.BUFFER);
                ZipEntry entry = new ZipEntry(Utils.unAccent((String)correspondingFilePath.get(file)));
                out.putNextEntry(entry);
                while ((count = buffi.read(data, 0, Utils.BUFFER)) != -1) {
                    out.write(data, 0, count);
                }
                out.closeEntry();
                buffi.close();
            }
            out.close();
            buff.close();
            checksum.close();
            dest.close();
        }
        catch (Exception e) {
            tree2dump.getUtils().setErrorMessage(Utils.getBundleConfElement("message.creatingFileError"), e);
            e.printStackTrace();
        }
        return zipFile;
    }

    private static void iterativeBreadthFirstSkipChildlessNodes(SingleAccessKeyNode rootNode, HashMap<SingleAccessKeyNode, Integer> nodeBreadthFirstIterationMap, int counter) {
        LinkedList<SingleAccessKeyNode> queue = new LinkedList<SingleAccessKeyNode>();
        ArrayList<SingleAccessKeyNode> visitedNodes = new ArrayList<SingleAccessKeyNode>();
        queue.add(rootNode);
        nodeBreadthFirstIterationMap.put(rootNode, new Integer(counter));
        ++counter;
        visitedNodes.add(rootNode);
        while (!queue.isEmpty()) {
            SingleAccessKeyNode node = (SingleAccessKeyNode)queue.remove();
            SingleAccessKeyNode child = null;
            while (Utils.exclusion(node.getChildren(), visitedNodes).size() > 0 && (child = (SingleAccessKeyNode)Utils.exclusion(node.getChildren(), visitedNodes).get(0)) != null) {
                visitedNodes.add(child);
                if (child.hasChild()) {
                    nodeBreadthFirstIterationMap.put(child, new Integer(counter));
                    ++counter;
                }
                queue.add(child);
            }
        }
    }

    private static void iterativeBreadthFirst(SingleAccessKeyNode rootNode, HashMap<SingleAccessKeyNode, Integer> nodeBreadthFirstIterationMap, int counter) {
        LinkedList<SingleAccessKeyNode> queue = new LinkedList<SingleAccessKeyNode>();
        ArrayList<SingleAccessKeyNode> visitedNodes = new ArrayList<SingleAccessKeyNode>();
        queue.add(rootNode);
        nodeBreadthFirstIterationMap.put(rootNode, new Integer(counter));
        ++counter;
        visitedNodes.add(rootNode);
        while (!queue.isEmpty()) {
            SingleAccessKeyNode node = (SingleAccessKeyNode)queue.remove();
            SingleAccessKeyNode child = null;
            while (Utils.exclusion(node.getChildren(), visitedNodes).size() > 0 && (child = (SingleAccessKeyNode)Utils.exclusion(node.getChildren(), visitedNodes).get(0)) != null) {
                visitedNodes.add(child);
                nodeBreadthFirstIterationMap.put(child, new Integer(counter));
                ++counter;
                queue.add(child);
            }
        }
    }

    private static void recursiveDepthFirstIntegerIndex(SingleAccessKeyNode node, HashMap<SingleAccessKeyNode, Integer> nodeBreadthFirstIterationMap, HashMap<Integer, Integer> nodeChildParentNumberingMap) {
        Integer parentNumber = nodeBreadthFirstIterationMap.get(node);
        for (SingleAccessKeyNode childNode : node.getChildren()) {
            Integer childNumber = nodeBreadthFirstIterationMap.get(childNode);
            nodeChildParentNumberingMap.put(childNumber, parentNumber);
            SingleAccessKeyTreeDumper.recursiveDepthFirstIntegerIndex(childNode, nodeBreadthFirstIterationMap, nodeChildParentNumberingMap);
        }
    }

    private static void recursiveDepthFirstNodeIndex(SingleAccessKeyNode node, HashMap<SingleAccessKeyNode, Integer> nodeBreadthFirstIterationMap, HashMap<SingleAccessKeyNode, Integer> nodeChildParentNumberingMap) {
        Integer parentNumber = nodeBreadthFirstIterationMap.get(node);
        for (SingleAccessKeyNode childNode : node.getChildren()) {
            nodeChildParentNumberingMap.put(childNode, parentNumber);
            SingleAccessKeyTreeDumper.recursiveDepthFirstNodeIndex(childNode, nodeBreadthFirstIterationMap, nodeChildParentNumberingMap);
        }
    }

    private static void recursiveDepthFirstIntegerIndex(SingleAccessKeyNode node, HashMap<SingleAccessKeyNode, Integer> nodeBreadthFirstIterationMap, HashMap<Integer, Integer> nodeChildParentNumberingMap, List<Integer> rootNodeChildrenIntegerList) {
        Integer parentNumber = nodeBreadthFirstIterationMap.get(node);
        for (SingleAccessKeyNode childNode : node.getChildren()) {
            Integer childNumber = nodeBreadthFirstIterationMap.get(childNode);
            nodeChildParentNumberingMap.put(childNumber, parentNumber);
            if (parentNumber == 1) {
                rootNodeChildrenIntegerList.add(childNumber);
            }
            SingleAccessKeyTreeDumper.recursiveDepthFirstIntegerIndex(childNode, nodeBreadthFirstIterationMap, nodeChildParentNumberingMap, rootNodeChildrenIntegerList);
        }
    }

    private static void recursiveDepthFirstNodeIndex(SingleAccessKeyNode node, HashMap<SingleAccessKeyNode, Integer> nodeBreadthFirstIterationMap, HashMap<SingleAccessKeyNode, Integer> nodeChildParentNumberingMap, List<SingleAccessKeyNode> rootNodeChildrenIntegerList) {
        Integer parentNumber = nodeBreadthFirstIterationMap.get(node);
        for (SingleAccessKeyNode childNode : node.getChildren()) {
            nodeChildParentNumberingMap.put(childNode, parentNumber);
            if (parentNumber == 1) {
                rootNodeChildrenIntegerList.add(childNode);
            }
            SingleAccessKeyTreeDumper.recursiveDepthFirstNodeIndex(childNode, nodeBreadthFirstIterationMap, nodeChildParentNumberingMap, rootNodeChildrenIntegerList);
        }
    }

    private static String escapeHTMLSpecialCharacters(String htmlString) {
        return htmlString.replace(">", "&gt;").replace("<", "&lt;").replace("&", "&amp;");
    }

    private static String outputTaxonPathStatisticsString(SingleAccessKeyTree tree2dump) {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer output = new StringBuffer(0);
        DataSet ds = tree2dump.getDataSet();
        float sumNbPath = 0.0f;
        float sumMinPathLength = 0.0f;
        float sumAvgPathLength = 0.0f;
        float sumMaxPathLength = 0.0f;
        int c = 0;
        output.append(String.valueOf(lineSeparator) + lineSeparator + lineSeparator + "STATISTICS" + lineSeparator);
        output.append("Taxon\tnumber of paths leading to taxon\t");
        output.append("length of the shortest path leading to taxon\t");
        output.append("average length of paths leading to taxon\t");
        output.append("length of the longest path leading to taxon\t");
        output.append(lineSeparator);
        for (Taxon t : ds.getTaxa()) {
            output.append(String.valueOf(t.getName()) + "\t" + t.getTaxonStatistics().get(0).intValue() + "\t" + t.getTaxonStatistics().get(1).intValue() + "\t" + Utils.roundFloat(t.getTaxonStatistics().get(3).floatValue(), 3) + "\t" + t.getTaxonStatistics().get(2).intValue());
            sumNbPath += t.getTaxonStatistics().get(0).floatValue();
            sumMinPathLength += t.getTaxonStatistics().get(1).floatValue();
            sumMaxPathLength += t.getTaxonStatistics().get(2).floatValue();
            sumAvgPathLength += t.getTaxonStatistics().get(3).floatValue();
            ++c;
            output.append(lineSeparator);
        }
        float averageNbPath = Utils.roundFloat(sumNbPath / (float)c, 3);
        float averageMinPath = Utils.roundFloat(sumMinPathLength / (float)c, 3);
        float averageAvgPath = Utils.roundFloat(sumAvgPathLength / (float)c, 3);
        float averageMaxPath = Utils.roundFloat(sumMaxPathLength / (float)c, 3);
        output.append("AVERAGE\t" + averageNbPath + "\t" + averageMinPath + "\t" + averageAvgPath + "\t" + averageMaxPath);
        output.append(lineSeparator);
        return output.toString();
    }

    private static String outputTaxonPathStatisticsHTML(SingleAccessKeyTree tree2dump) {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer output = new StringBuffer(0);
        DataSet ds = tree2dump.getDataSet();
        output.append("<div style=\"margin-left: 30px;word-wrap: break-word;\" id=\"statistics\">" + lineSeparator);
        output.append("<br/><br/><strong>STATISTICS</strong>" + lineSeparator);
        output.append("<table class=\"statisticsTable\">" + lineSeparator);
        float sumNbPath = 0.0f;
        float sumMinPathLength = 0.0f;
        float sumAvgPathLength = 0.0f;
        float sumMaxPathLength = 0.0f;
        int c = 0;
        output.append("<tr>" + lineSeparator);
        output.append("<td>Taxon</td>");
        output.append("<td width=\"100px;\">Number of paths leading to taxon</td>");
        output.append("<td width=\"100px;\">Length of the shortest path leading to taxon</td>");
        output.append("<td width=\"100px;\">Average length of paths leading to taxon</td>");
        output.append("<td width=\"100px;\">Length of the longest path leading to taxon</td>");
        output.append("</tr>" + lineSeparator);
        for (Taxon t : ds.getTaxa()) {
            if (c % 2 != 0) {
                output.append("<tr style=\"background: #e5e5e5;\">" + lineSeparator);
            } else {
                output.append("<tr>" + lineSeparator);
            }
            output.append("<td>" + SingleAccessKeyTreeDumper.escapeHTMLSpecialCharacters(t.getName()) + "</td><td>" + t.getTaxonStatistics().get(0).intValue() + "</td><td>" + t.getTaxonStatistics().get(1).intValue() + "</td><td>" + Utils.roundFloat(t.getTaxonStatistics().get(3).floatValue(), 3) + "</td><td>" + t.getTaxonStatistics().get(2).intValue() + "</td>");
            sumNbPath += t.getTaxonStatistics().get(0).floatValue();
            sumMinPathLength += t.getTaxonStatistics().get(1).floatValue();
            sumMaxPathLength += t.getTaxonStatistics().get(2).floatValue();
            sumAvgPathLength += t.getTaxonStatistics().get(3).floatValue();
            ++c;
            output.append("</tr>" + lineSeparator);
        }
        float averageNbPath = Utils.roundFloat(sumNbPath / (float)c, 3);
        float averageMinPath = Utils.roundFloat(sumMinPathLength / (float)c, 3);
        float averageAvgPath = Utils.roundFloat(sumAvgPathLength / (float)c, 3);
        float averageMaxPath = Utils.roundFloat(sumMaxPathLength / (float)c, 3);
        output.append("<tr><td>AVERAGE</td><td>" + averageNbPath + "</td><td>" + averageMinPath + "</td><td>" + averageAvgPath + "</td><td>" + averageMaxPath + "</td></tr>");
        output.append(lineSeparator);
        output.append("</table>" + lineSeparator);
        output.append("</div>" + lineSeparator);
        return output.toString();
    }

    private static String outputTaxonPathStatisticsWiki(SingleAccessKeyTree tree2dump) {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer output = new StringBuffer(0);
        DataSet ds = tree2dump.getDataSet();
        float sumNbPath = 0.0f;
        float sumMinPathLength = 0.0f;
        float sumAvgPathLength = 0.0f;
        float sumMaxPathLength = 0.0f;
        int c = 0;
        output.append(String.valueOf(lineSeparator) + lineSeparator + "== STATISTICS == " + lineSeparator);
        output.append("{|align=\"center\" style=\"text-align:center;\"" + lineSeparator);
        output.append("!Taxon" + lineSeparator);
        output.append("!Number of paths leading to taxon" + lineSeparator);
        output.append("!Length of the shortest path leading to taxon" + lineSeparator);
        output.append("!Average length of paths leading to taxon" + lineSeparator);
        output.append("!Length of the longest path leading to taxon" + lineSeparator);
        output.append("|-" + lineSeparator);
        for (Taxon t : ds.getTaxa()) {
            output.append("|align=\"left\"|" + t.getName() + lineSeparator + "|" + t.getTaxonStatistics().get(0).intValue() + lineSeparator + "|" + t.getTaxonStatistics().get(1).intValue() + lineSeparator + "|" + Utils.roundFloat(t.getTaxonStatistics().get(3).floatValue(), 3) + lineSeparator + "|" + t.getTaxonStatistics().get(2).intValue() + lineSeparator + "|-" + lineSeparator);
            sumNbPath += t.getTaxonStatistics().get(0).floatValue();
            sumMinPathLength += t.getTaxonStatistics().get(1).floatValue();
            sumMaxPathLength += t.getTaxonStatistics().get(2).floatValue();
            sumAvgPathLength += t.getTaxonStatistics().get(3).floatValue();
            ++c;
        }
        float averageNbPath = Utils.roundFloat(sumNbPath / (float)c, 3);
        float averageMinPath = Utils.roundFloat(sumMinPathLength / (float)c, 3);
        float averageAvgPath = Utils.roundFloat(sumAvgPathLength / (float)c, 3);
        float averageMaxPath = Utils.roundFloat(sumMaxPathLength / (float)c, 3);
        output.append("!align=\"left\"|AVERAGE" + lineSeparator + "|" + averageNbPath + lineSeparator + "|" + averageMinPath + lineSeparator + "|" + averageAvgPath + lineSeparator + "|" + averageMaxPath + lineSeparator + "|}");
        output.append(lineSeparator);
        return output.toString();
    }
}

