/*
 * Decompiled with CFR 0.152.
 */
package main.java.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import main.java.model.CategoricalCharacter;
import main.java.model.CodedDescription;
import main.java.model.ICharacter;
import main.java.model.State;
import main.java.model.Taxon;

public class DataSet {
    private List<ICharacter> characters = new ArrayList<ICharacter>();
    private Map<Taxon, CodedDescription> codedDescriptions = new LinkedHashMap<Taxon, CodedDescription>();
    private String label = null;
    private Map<String, String> mediaObjects = new LinkedHashMap<String, String>();

    public List<ICharacter> getCharacters() {
        return this.characters;
    }

    public void setCharacters(List<ICharacter> characters) {
        this.characters = characters;
    }

    public Map<Taxon, CodedDescription> getCodedDescriptions() {
        return this.codedDescriptions;
    }

    public void setCodedDescriptions(Map<Taxon, CodedDescription> codedDescriptions) {
        this.codedDescriptions = codedDescriptions;
    }

    public CodedDescription getCodedDescription(Taxon taxon) {
        return this.codedDescriptions.get(taxon);
    }

    public void addCodedDescription(Taxon taxon, CodedDescription codedDescription) {
        this.codedDescriptions.put(taxon, codedDescription);
    }

    public void removeCodedDescription(Taxon taxon) {
        this.codedDescriptions.remove(taxon);
    }

    public List<Taxon> getTaxa() {
        return new ArrayList<Taxon>(this.codedDescriptions.keySet());
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public ICharacter getCharacterById(String id) {
        for (ICharacter character : this.characters) {
            if (!character.getId().equals(id)) continue;
            return character;
        }
        return null;
    }

    public State getStateById(String id) {
        for (ICharacter character : this.characters) {
            if (!(character instanceof CategoricalCharacter)) continue;
            for (State state : ((CategoricalCharacter)character).getStates()) {
                if (!state.getId().equals(id)) continue;
                return state;
            }
        }
        return null;
    }

    public ICharacter getCharacterByState(State state) {
        for (ICharacter character : this.characters) {
            if (!(character instanceof CategoricalCharacter)) continue;
            for (State stateBis : ((CategoricalCharacter)character).getStates()) {
                if (stateBis != state) continue;
                return character;
            }
        }
        return null;
    }

    public Map<String, String> getMediaObjects() {
        return this.mediaObjects;
    }

    public void setMediaObjects(Map<String, String> mediaObjects) {
        this.mediaObjects = mediaObjects;
    }

    public String getMediaObject(String key) {
        return this.mediaObjects.get(key);
    }

    public boolean isApplicable(Taxon taxon, ICharacter character) {
        if (character.getParentCharacter() != null && this.isApplicable(taxon, character.getParentCharacter())) {
            State state;
            List<State> inapplicableStates = character.getInapplicableStates();
            List states = (List)this.getCodedDescription(taxon).getCharacterDescription(character.getParentCharacter());
            if (states == null) {
                return true;
            }
            int i = 0;
            while (i < states.size()) {
                state = (State)states.get(i);
                if (!inapplicableStates.contains(state)) {
                    return true;
                }
                ++i;
            }
            i = 0;
            while (i < states.size()) {
                state = (State)states.get(i);
                if (inapplicableStates.contains(state)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public List<ICharacter> getInapplicableCharacters(List<ICharacter> newRemainingCharacters, ICharacter selectedCharacter, State state) {
        ArrayList<ICharacter> inapplicableCharacter = new ArrayList<ICharacter>();
        for (ICharacter character : newRemainingCharacters) {
            if (!character.getInapplicableStates().contains(state)) continue;
            inapplicableCharacter.add(character);
            inapplicableCharacter.addAll(character.getAllChildren());
        }
        return inapplicableCharacter;
    }
}

