/*
 * Decompiled with CFR 0.152.
 */
package main.java.model;

import main.java.model.DataSet;
import main.java.model.QuantitativeCharacter;
import main.java.model.QuantitativeMeasure;
import main.java.model.SingleAccessKeyNode;
import main.java.model.Taxon;
import main.java.utils.Utils;

public class SingleAccessKeyTree {
    private SingleAccessKeyNode root = null;
    private DataSet dataSet = null;
    private Utils utils = null;

    public SingleAccessKeyTree(Utils utils) {
        this(null, utils);
    }

    public SingleAccessKeyTree(SingleAccessKeyNode root, Utils utils) {
        this.root = root;
        this.utils = utils;
    }

    public SingleAccessKeyNode getRoot() {
        return this.root;
    }

    public void setRoot(SingleAccessKeyNode root) {
        this.root = root;
    }

    public String getLabel() {
        return this.dataSet.getLabel();
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
    }

    public Utils getUtils() {
        return this.utils;
    }

    public void setUtils(Utils utils) {
        this.utils = utils;
    }

    private void recursiveToString(SingleAccessKeyNode node, StringBuffer output, String tabulations, int firstNumbering, int secondNumbering) {
        if (node != null && node.getCharacter() != null && node.getCharacterState() != null) {
            if (node.getCharacterState() instanceof QuantitativeMeasure) {
                output.append(String.valueOf(tabulations) + firstNumbering + "." + secondNumbering + ") " + node.getCharacter().getName() + " | " + ((QuantitativeMeasure)node.getCharacterState()).toStringInterval(((QuantitativeCharacter)node.getCharacter()).getMeasurementUnit()));
            } else {
                output.append(String.valueOf(tabulations) + firstNumbering + "." + secondNumbering + ") " + node.getCharacter().getName() + " | " + node.getStringStates());
            }
            output.append(this.nodeDescriptionAnalysis(node));
            if (node.getChildren().size() == 0) {
                output.append(" -> ");
                boolean firstLoop = true;
                for (Taxon taxon : node.getRemainingTaxa()) {
                    if (!firstLoop) {
                        output.append(", ");
                    }
                    output.append(taxon.getName());
                    firstLoop = false;
                }
            } else {
                output.append(" (items=" + node.getRemainingTaxa().size() + ")");
            }
            tabulations = String.valueOf(tabulations) + "\t";
        }
        ++firstNumbering;
        secondNumbering = 0;
        for (SingleAccessKeyNode childNode : node.getChildren()) {
            this.recursiveToString(childNode, output, tabulations, firstNumbering, ++secondNumbering);
        }
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        this.recursiveToString(this.root, output, System.getProperty("line.separator"), 0, 0);
        return output.toString();
    }

    public String nodeDescriptionAnalysis(SingleAccessKeyNode node) {
        if (node.getNodeDescription() != null && node.getNodeDescription().trim().length() > 0 && this.utils.getVerbosity().contains("w")) {
            return " (" + node.getNodeDescription() + ")";
        }
        return "";
    }

    public void gatherTaxonPathStatistics() {
        this.recursiveTaxonPathStatistics(this.root, 1);
    }

    private void recursiveTaxonPathStatistics(SingleAccessKeyNode node, int treeDepth) {
        if (node != null && node.getCharacter() != null && node.getCharacterState() != null) {
            if (!node.hasChild()) {
                for (Taxon t : node.getRemainingTaxa()) {
                    t.updatePathStatistics(new Float(treeDepth));
                }
            }
            ++treeDepth;
        }
        for (SingleAccessKeyNode childNode : node.getChildren()) {
            this.recursiveTaxonPathStatistics(childNode, treeDepth);
        }
    }
}

