/*
 * Decompiled with CFR 0.152.
 */
package main.java.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;

public class Utils {
    private String errorMessage = null;
    private File errorMessageFile = null;
    public static final String UNKNOWN_DATA = "unknownData";
    public static final List<String> ratings = new ArrayList<String>();
    public static final List<String> ratingContext = new ArrayList<String>();
    public static final String YES = "yes";
    public static final String NO = "no";
    public static final String HEADER_TAG = "h";
    public static final String OTHER_TAG = "o";
    public static final String WARNING_TAG = "w";
    public static final String STATISTIC_TAG = "s";
    public static final int DEFAULT_WEIGHT = 3;
    public static ResourceBundle bundleConf = ResourceBundle.getBundle("main.resources.conf");
    public static ResourceBundle bundleConfOverridable = ResourceBundle.getBundle("main.resources.confOverridable");
    public static int BUFFER = 2048;
    public static final String KEY = "key_";
    public static final String ERROR = "error_";
    public static final String TXT = "txt";
    public static final String HTML = "html";
    public static final String INTERACTIVE_HTML = "interactivehtml";
    public static final String PDF = "pdf";
    public static final String SDD = "sdd";
    public static final String WIKI = "wiki";
    public static final String SPECIESIDWIKISTATEMENT = "speciesidwikistatement";
    public static final String SPECIESIDWIKIQUESTIONANSWER = "speciesidwikiquestionanswer";
    public static final String DOT = "dot";
    public static final String ZIP = "zip";
    public static final String GV = "gv";
    public static final String TREE = "tree";
    public static final String FLAT = "flat";
    public static final String XPER = "xper";
    public static final String JACCARD = "jaccard";
    public static final String SOKALANDMICHENER = "sokalAndMichener";
    public static final String GLOBAL_CHARACTER_WEIGHT = "global";
    public static final String CONTEXTUAL_CHARACTER_WEIGHT = "contextual";
    private String format = "txt";
    private String representation = "tree";
    private boolean fewStatesCharacterFirst = false;
    private boolean mergeCharacterStatesIfSameDiscimination = false;
    private boolean pruning = false;
    private String verbosity = "";
    private String scoreMethod = "xper";
    private String weightContext = "";
    private String weightType = "global";

    public Utils() {
        ratings.add("Rating1of5");
        ratings.add("Rating2of5");
        ratings.add("Rating3of5");
        ratings.add("Rating4of5");
        ratings.add("Rating5of5");
        ratingContext.add("ObservationConvenience");
        ratingContext.add("Availability");
        ratingContext.add("Repeatability");
        ratingContext.add("CostEffectiveness");
        ratingContext.add("PhylogeneticWeighting");
        ratingContext.add("RequiredExpertise");
    }

    public static Double convertStringToDouble(String str) {
        try {
            Double doubleValue = new Double(Double.parseDouble(str));
            return doubleValue;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getBundleConfElement(String key) {
        return bundleConf.getString(key);
    }

    public static String getBundleConfOverridableElement(String key) {
        return bundleConfOverridable.getString(key);
    }

    public static void setBundleConf(ResourceBundle bundleConf) {
        Utils.bundleConf = bundleConf;
    }

    public static void setBundleConfOverridable(ResourceBundle bundleConfOverridable) {
        Utils.bundleConfOverridable = bundleConfOverridable;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String msg) {
        if (this.getErrorMessage() == null) {
            this.errorMessage = msg;
            this.setErrorMessageFile(this.createErrorFile());
        }
    }

    public void setErrorMessage(String msg, Throwable t) {
        if (this.getErrorMessage() == null) {
            this.errorMessage = String.valueOf(msg) + ": " + t.getMessage();
            this.setErrorMessageFile(this.createErrorFile());
        }
    }

    public File getErrorMessageFile() {
        return this.errorMessageFile;
    }

    public void setErrorMessageFile(File errorMessageFile) {
        this.errorMessageFile = errorMessageFile;
    }

    public File createErrorFile() {
        String path = String.valueOf(Utils.getBundleConfOverridableElement("generatedKeyFiles.prefix")) + Utils.getBundleConfOverridableElement("generatedKeyFiles.folder");
        String lineReturn = System.getProperty("line.separator");
        File erroFile = null;
        try {
            erroFile = File.createTempFile(ERROR, ".txt", new File(path));
            FileOutputStream fileOutputStream = new FileOutputStream(erroFile);
            fileOutputStream.write(new byte[]{-17, -69, -65});
            BufferedWriter txtFileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"));
            txtFileWriter.append(this.errorMessage);
            txtFileWriter.append(String.valueOf(lineReturn) + lineReturn + Utils.getBundleConfElement("message.webmaster") + Utils.getBundleConfOverridableElement("email.webmaster"));
            txtFileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return erroFile;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getRepresentation() {
        return this.representation;
    }

    public void setRepresentation(String representation) {
        this.representation = representation;
    }

    public boolean isFewStatesCharacterFirst() {
        return this.fewStatesCharacterFirst;
    }

    public void setFewStatesCharacterFirst(boolean fewStatesCharacterFirst) {
        this.fewStatesCharacterFirst = fewStatesCharacterFirst;
    }

    public boolean isMergeCharacterStatesIfSameDiscimination() {
        return this.mergeCharacterStatesIfSameDiscimination;
    }

    public void setMergeCharacterStatesIfSameDiscimination(boolean mergeCharacterStatesIfSameDiscimination) {
        this.mergeCharacterStatesIfSameDiscimination = mergeCharacterStatesIfSameDiscimination;
    }

    public boolean isPruning() {
        return this.pruning;
    }

    public void setPruning(boolean pruning) {
        this.pruning = pruning;
    }

    public String getVerbosity() {
        return this.verbosity;
    }

    public void setVerbosity(String verbosity) {
        this.verbosity = verbosity;
    }

    public String getScoreMethod() {
        return this.scoreMethod;
    }

    public void setScoreMethod(String scoreMethod) {
        this.scoreMethod = scoreMethod;
    }

    public String getWeightContext() {
        return this.weightContext;
    }

    public void setWeightContext(String weightContext) {
        for (String ratingContext : Utils.ratingContext) {
            if (!weightContext.equalsIgnoreCase(ratingContext)) continue;
            this.weightContext = ratingContext;
        }
    }

    public String getWeightType() {
        return this.weightType;
    }

    public void setWeightType(String weightType) {
        this.weightType = weightType;
    }

    public static List<?> intersection(List<?> list1, List<?> list2) {
        ArrayList list = new ArrayList();
        for (Object o : list1) {
            if (!list2.contains(o)) continue;
            list.add(o);
        }
        return list;
    }

    public static List<?> exclusion(List<?> primaryList, List<?> excludedList) {
        ArrayList list = new ArrayList();
        for (Object o : primaryList) {
            if (excludedList.contains(o)) continue;
            list.add(o);
        }
        return list;
    }

    public static List<?> union(List<?> list1, List<?> list2) {
        HashSet set = new HashSet();
        set.addAll(list1);
        set.addAll(list2);
        return new ArrayList(set);
    }

    public static float roundFloat(float floatToRound, int roundFactor) {
        double roundedFloat = 0.0;
        double multiplier = Math.pow(10.0, roundFactor);
        roundedFloat = multiplier * (double)floatToRound;
        roundedFloat = (int)(roundedFloat + 0.5);
        return (float)(roundedFloat /= multiplier);
    }

    public static double roundDouble(double score, int roundFactor) {
        double roundedDouble = 0.0;
        double multiplier = Math.pow(10.0, roundFactor);
        roundedDouble = multiplier * score;
        roundedDouble = (int)(roundedDouble + 0.5);
        return (float)(roundedDouble /= multiplier);
    }

    public static String unAccent(String s) {
        String temp = Normalizer.normalize(s, Normalizer.Form.NFC);
        return temp.replaceAll("[^\\p{ASCII}]", "");
    }
}

