/*
 * Decompiled with CFR 0.152.
 */
package test.java.IO;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import main.java.IO.SDDSaxParser;
import main.java.model.CategoricalCharacter;
import main.java.model.CodedDescription;
import main.java.model.DataSet;
import main.java.model.ICharacter;
import main.java.model.QuantitativeMeasure;
import main.java.model.State;
import main.java.model.Taxon;
import main.java.utils.Utils;
import org.junit.Test;

public class SDDSaxParserTest {
    public Logger logger = Logger.getAnonymousLogger();

    @Test
    public void testSDDSaxParser() {
        this.logger.info("testSDDSaxParser");
        long beforeTime = System.currentTimeMillis();
        Utils utils = new Utils();
        SDDSaxParser sddSaxParser = null;
        try {
            String stringUrl = "http://www.infosyslab.fr/vibrant/project/test/varanusSDD_RatingExample.xml";
            utils.setFewStatesCharacterFirst(false);
            utils.setMergeCharacterStatesIfSameDiscimination(false);
            utils.setPruning(false);
            utils.setVerbosity("how");
            utils.setScoreMethod("xper");
            utils.setWeightContext("CostEffectiveness");
            try {
                URL fileURL = new URL(stringUrl);
                URLConnection urlConnection = fileURL.openConnection();
                InputStream httpStream = urlConnection.getInputStream();
            }
            catch (MalformedURLException e) {
                utils.setErrorMessage(Utils.getBundleConfElement("message.urlError"), e);
                e.printStackTrace();
            }
            catch (IOException e) {
                utils.setErrorMessage(Utils.getBundleConfElement("message.urlError"), e);
                e.printStackTrace();
            }
            sddSaxParser = new SDDSaxParser(stringUrl, utils);
        }
        catch (Throwable t) {
            utils.setErrorMessage(Utils.getBundleConfElement("message.parsingError"), t);
            t.printStackTrace();
        }
        double parseDuration = (double)(System.currentTimeMillis() - beforeTime) / 1000.0;
        DataSet dataset = sddSaxParser.getDataset();
        if (dataset != null) {
            System.out.println("dataSetLabel : " + dataset.getLabel());
            System.out.println("characters (" + dataset.getCharacters().size() + ") : ");
            for (ICharacter character : dataset.getCharacters()) {
                if (character instanceof CategoricalCharacter) {
                    System.out.println("\t" + character.getName() + "   w=" + character.getWeight());
                    for (State state : ((CategoricalCharacter)character).getStates()) {
                        System.out.println("\t\t" + state.getName());
                        for (String key : state.getMediaObjectKeys()) {
                            System.out.println("\t" + key);
                        }
                    }
                    continue;
                }
                System.out.println("\t*N*" + character.getName() + "   w=" + character.getWeight());
            }
            System.out.println("taxa (" + dataset.getTaxa().size() + ") : ");
            for (Taxon taxon : dataset.getTaxa()) {
                System.out.println("\t" + taxon.getName());
                for (String key : taxon.getMediaObjectKeys()) {
                    System.out.println("\t" + key);
                }
                CodedDescription codedDescription = dataset.getCodedDescription(taxon);
                for (ICharacter character : dataset.getCharacters()) {
                    Object characterDescription = codedDescription.getCharacterDescription(character);
                    if (characterDescription == null) continue;
                    System.out.println("\t\t" + character.getName());
                    if (characterDescription instanceof QuantitativeMeasure) {
                        System.out.println("\t\t\t" + ((QuantitativeMeasure)characterDescription).toString());
                        continue;
                    }
                    if (!(characterDescription instanceof ArrayList)) continue;
                    for (State state : (List)characterDescription) {
                        System.out.println("\t\t\t" + state.getName());
                    }
                }
            }
            System.out.println("characterTree by parent : ");
            for (ICharacter character : dataset.getCharacters()) {
                if (character.getParentCharacter() == null) continue;
                System.out.println("\tcharacter->" + character.getName());
                System.out.println("\tparent->" + character.getParentCharacter().getName());
                for (State state : character.getInapplicableStates()) {
                    System.out.println("\t\t" + state.getName());
                }
            }
            System.out.println("characterTree by children : ");
            for (ICharacter character : dataset.getCharacters()) {
                if (character.getParentCharacter() != null) continue;
                this.displayRecursiveChildren("\t", character);
            }
            System.out.println("media objects : ");
            for (String key : dataset.getMediaObjects().keySet()) {
                System.out.println(String.valueOf(key) + " : " + dataset.getMediaObjects().get(key));
            }
        } else {
            System.out.println("dataset is null !");
        }
        System.out.println(String.valueOf(System.getProperty("line.separator")) + "parseDuration= " + parseDuration + "s");
    }

    private void displayRecursiveChildren(String tabulations, ICharacter character) {
        System.out.println(String.valueOf(tabulations) + "character->" + character.getName());
        for (State state : character.getInapplicableStates()) {
            System.out.println(String.valueOf(tabulations) + "\tInappState:" + state.getName());
        }
        for (ICharacter childCharacter : character.getChildCharacters()) {
            this.displayRecursiveChildren(String.valueOf(tabulations) + "\t", childCharacter);
        }
    }
}

