/*
 * Decompiled with CFR 0.152.
 */
package test.java.services;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import main.java.IO.SDDSaxParser;
import main.java.IO.SingleAccessKeyTreeDumper;
import main.java.model.SingleAccessKeyTree;
import main.java.services.IdentificationKeyGenerator;
import main.java.utils.Utils;
import org.junit.Test;

public class IdentificationKeyWIKIGeneratorTest {
    public Logger logger = Logger.getAnonymousLogger();

    @Test
    public void testIdentificationKeyGenerator() {
        Utils utils = new Utils();
        Utils.setBundleConfOverridable(ResourceBundle.getBundle("test.resources.confTest"));
        Utils.setBundleConf(ResourceBundle.getBundle("test.resources.confTest"));
        String resultFileName = "";
        try {
            this.logger.info("testIdentificationKeyGenerator");
            long beforeTime = System.currentTimeMillis();
            StringBuffer header = new StringBuffer();
            SDDSaxParser sddSaxParser = null;
            try {
                String stringUrl = "http://www.infosyslab.fr/vibrant/project/test/Cichorieae-fullSDD.xml";
                utils.setFewStatesCharacterFirst(false);
                utils.setMergeCharacterStatesIfSameDiscimination(false);
                utils.setPruning(false);
                utils.setVerbosity("hows");
                utils.setScoreMethod("xper");
                utils.setWeightContext("CostEffectiveness");
                utils.setWeightType("global");
                try {
                    URL fileURL = new URL(stringUrl);
                    URLConnection urlConnection = fileURL.openConnection();
                    urlConnection.getInputStream();
                }
                catch (MalformedURLException e) {
                    utils.setErrorMessage(Utils.getBundleConfElement("message.urlError"), e);
                    e.printStackTrace();
                }
                catch (IOException e) {
                    utils.setErrorMessage(Utils.getBundleConfElement("message.urlError"), e);
                    e.printStackTrace();
                }
                sddSaxParser = new SDDSaxParser(stringUrl, utils);
                header.append(String.valueOf(System.getProperty("line.separator")) + sddSaxParser.getDataset().getLabel() + ", " + Utils.getBundleConfOverridableElement("message.createdBy") + System.getProperty("line.separator"));
                header.append(String.valueOf(System.getProperty("line.separator")) + "Options:");
                header.append(String.valueOf(System.getProperty("line.separator")) + "sddURL=" + stringUrl);
                header.append(String.valueOf(System.getProperty("line.separator")) + "fewStatesCharacterFirst=" + utils.isFewStatesCharacterFirst());
                header.append(String.valueOf(System.getProperty("line.separator")) + "mergeCharacterStatesIfSameDiscimination=" + utils.isMergeCharacterStatesIfSameDiscimination());
                header.append(String.valueOf(System.getProperty("line.separator")) + "pruning=" + utils.isPruning());
                header.append(String.valueOf(System.getProperty("line.separator")) + "verbosity=" + utils.getVerbosity());
                header.append(String.valueOf(System.getProperty("line.separator")) + "scoreMethod=" + utils.getScoreMethod());
                header.append(String.valueOf(System.getProperty("line.separator")) + "weightContext=" + utils.getWeightContext());
                header.append(String.valueOf(System.getProperty("line.separator")) + "weightType=" + utils.getWeightType() + System.getProperty("line.separator"));
            }
            catch (Throwable t) {
                utils.setErrorMessage(Utils.getBundleConfElement("message.parsingError"), t);
                t.printStackTrace();
            }
            double parseDuration = (double)(System.currentTimeMillis() - beforeTime) / 1000.0;
            beforeTime = System.currentTimeMillis();
            IdentificationKeyGenerator identificationKeyGenerator = null;
            try {
                identificationKeyGenerator = new IdentificationKeyGenerator(sddSaxParser.getDataset(), utils);
                identificationKeyGenerator.createIdentificationKey();
            }
            catch (Throwable t) {
                utils.setErrorMessage(Utils.getBundleConfElement("message.creatingKeyError"), t);
                t.printStackTrace();
            }
            double keyCreationDuration = (double)(System.currentTimeMillis() - beforeTime) / 1000.0;
            header.append(String.valueOf(System.getProperty("line.separator")) + "parseDuration= " + parseDuration + "s");
            header.append(String.valueOf(System.getProperty("line.separator")) + "keyCreationDuration= " + keyCreationDuration + "s");
            try {
                SingleAccessKeyTree tree2dump = identificationKeyGenerator.getSingleAccessKeyTree();
                header.append(String.valueOf(System.getProperty("line.separator")) + System.getProperty("line.separator"));
                if (!utils.getVerbosity().contains("h")) {
                    header.setLength(0);
                }
                resultFileName = SingleAccessKeyTreeDumper.dumpWikiFile(header.toString(), tree2dump, utils.getVerbosity().contains("s")).getName();
            }
            catch (IOException e) {
                utils.setErrorMessage(Utils.getBundleConfElement("message.creatingFileError"), e);
                e.printStackTrace();
            }
        }
        catch (Throwable t) {
            utils.setErrorMessage(Utils.getBundleConfElement("message.error"), t);
            t.printStackTrace();
        }
        if (utils.getErrorMessageFile() != null) {
            resultFileName = utils.getErrorMessageFile().getName();
        }
        System.out.println(resultFileName);
    }
}

